@extends('FrontEnd.Layouts.main')
@section('pagetitle')
  {{ __('messages.VIDEOS') . ' - ' . __('messages.SITENAME') }}
@endsection
@section('title')
  {{ __('messages.VIDEOS') }}
@endsection
@section('baseurl')
  {{ route('home') }}
@endsection
@section('logo')
  {{ asset('FrontEnd/imgs/logo.png') }}
@endsection
@section('image')
  {{ asset('FrontEnd/imgs/logo.png') }}
@endsection
@section('description')
  {{ __('messages.SITENAME') . ' | ' . __('messages.SITESLOGAN') }}
@endsection

@section('content')
  @if (Session::has('success'))
    <div class="alert alert-success text-center">
      {{ Session::get('success') }}
    </div>
  @endif
  @if (Session::has('error'))
    <div class="alert alert-danger text-center">
      {{ Session::get('error') }}
    </div>
  @endif
  <section class="video-news-area ptb-40">
    <div class="container">
      @include('FrontEnd.Layouts.breadcrumb')
      {{-- <div class="shorting-menu">
        <button class="filter" data-filter="all"><a href="{{ route($route_all) }}">{{ __('messages.SHOW_ALL') }}</a></button>
        @forelse ($albums as $album)
          <button class="filter" data-filter="all"><a href="{{ route($route, $album->slug) }}">
              <img src="{{ $album->image }}" alt="" style="height: 100px;"><br>
              {{ $album->name_ar }}
            </a></button>
        @empty
        @endforelse
      </div> --}}
      <div class="row">
        @if (count(Request::segments())==1)
        @forelse ($albums as $album)
        <div class="col-lg-4 col-sm-6 col-md-6">
          <a href="{{ route($route,$album->slug) }}" class="popup-btnxx">
          <div class="single-gallery-box">
            <img src="{{ $album->image }}" alt="{{ $album->name_ar }}" style="border: 1px solid lightgray;height:350px;width:100%;object-fit:cover;border-radius:20px;">

            <div class="gallery-content">
              <h3>{{ $album->name_ar }}</h3>
            </div>
          </div>
        </a>
        </div>
      
        @empty
          
        @endforelse
        @else
        @forelse ($videos as $video)
          <div class="col-lg-4 col-md-4">
            <div class="single-default-news">
              <img src="https://img.youtube.com/vi/{{ $video->video_code }}/0.jpg" alt="image">
              <div class="news-content">
                <h3><a href="https://www.youtube.com/watch?v={{ $video->video_code }}">{{ $video->name }}</a></h3>
              </div>
              <div class="video-btn">
                <a href="https://www.youtube.com/watch?v={{ $video->video_code }}" class="popup-youtube"><i
                    class="icofont-play-alt-3"></i></a>
              </div>
            </div>
          </div>
        @empty
        @endforelse
        @endif
      </div>
      <div class="col-md-12">
        {{-- {{ $videos->links() }} --}}
      </div>
    </div>
  </section>
@endsection
@push('custom')
@endpush
