@extends('FrontEnd.Layouts.main')
@section('pagetitle')ارشيف الاعداد pdf - {{ __('messages.SITENAME') .' | '. __('messages.SITESLOGAN') }}@endsection
@section('title') ارشيف الاعداد pdf @endsection
@section('baseurl') {{ route('page_newspapers') }}@endsection
@section('logo'){{ asset('FrontEnd/images/logo.jpg') }}@endsection
@section('image'){{ asset('FrontEnd/images/logo.jpg') }}@endsection
@section('keywords') ارشيف الاعداد pdf @endsection
@section('description') ارشيف الاعداد pdf @endsection

@section('content')
@if(Session::has('success'))
<div class="alert alert-success text-center">
  {{ Session::get('success') }}
</div>
@endif
@if(Session::has('error'))
<div class="alert alert-danger text-center">
  {{ Session::get('error') }}
</div>
@endif
<div class="container">
  @include('FrontEnd.Layouts.breadcrumb')
  <div class="row">
    @foreach ($newspapers as $newspaper)
      <div class="col-lg-4 col-sm-6 col-md-6">
        <div class="single-gallery-box">
          <img src="{{ $newspaper->image }}" alt="{{ $newspaper->publish_up }}">

          <div class="gallery-content">
            <h3>{{ 'العدد ('.$newspaper->newspaper_number.') '.$newspaper->publish_up }}</h3>
            {{-- <span class="category">Media</span> --}}
          </div>

          <div class="plus-icon">
            <a href="{{ route('page_pdf',$newspaper->publish_up) }}" class="popup-btnxx">
              <span></span>
            </a>
          </div>
        </div>
      </div>
    @endforeach
  </div>
</div>
@endsection
@push('custom')
@endpush