@extends('FrontEnd.Layouts.main')
@section('pagetitle'){{ __('messages.HOME') . ' | ' . __('messages.SITENAME') . ' - ' . __('messages.SITESLOGAN') }}@endsection
@section('title'){{ __('messages.SITENAME') }}@endsection
@section('baseurl'){{ route('home') }}@endsection
@section('logo'){{ asset('FrontEnd/images/logo.png') }}@endsection
@section('image'){{ asset('FrontEnd/images/logo.png') }}@endsection
{{-- @section('keywords'){{ json_decode($meta->meta_keywords,true)[LaravelLocalization::setLocale()] }}@endsection --}}
@section('description'){{ __('messages.HOME') . ' | ' . __('messages.SITENAME') . ' - ' . __('messages.SITESLOGAN') }}@endsection

@section('content')
  @if (session('success'))
    <div class="alert alert-success text-center">
      {{ session('success') }}
    </div>
  @endif
  @if (session('error'))
    <div class="alert alert-danger text-center">
      {{ session('error') }}
    </div>
  @endif
  {{-- slider --}}
  <section class="new-news-area ptb-20">
    <div class="container">
      <div class="row">
        <div class="col-lg-8 col-md-12">
          <div class="new-news-slides owl-carousel owl-theme">
            @foreach ($slider as $sl)
              <div class="single-default-news">
                <img src="{{ $sl->image }}" alt="{{ $sl->title }}" title='{{ $sl->title }}' class="center"
                  onerror="this.src='{{ $sl->image }}'" />
                <div class="news-content">
                  <h2><a href="{{ route('news_cat_details', [$sl->getCategory->slug, $sl->slug]) }}"
                      style="color: white;">{{ $sl->title }}</a>
                  </h2>
                  <ul>
                    <li><a
                        href="{{ route('news_cat_details', [$sl->getCategory->slug, $sl->slug]) }}">{{ $sl->subtitle }}</a>
                    </li>
                  </ul>
                </div>

              </div>
            @endforeach


          </div>
        </div>
        {{-- <div class="col-lg-4 col-md-12">
          <div class="new-news-list">
            @foreach ($slider2 as $sl)
              @if ($loop->iteration > 6)
                <div class="row subnews_slider">
                  <div class="col-4"><img src="{{ $sl->image }}" alt="{{ $sl->title }}"  title='{{ $sl->title }}' class="center" onerror="this.src='{{ $sl->image }}'"/></div>
                  <div class="col-8">
                    <div class="subnews-content">
                      <h3><a
                          href="{{ route('news_cat_details', [$sl->getCategory->slug, $sl->slug]) }}">{{ $sl->title }}</a>
                      </h3>
                    </div>
                  </div>
                </div>
              @endif
            @endforeach
          </div>
        </div> --}}
        <div class="col-lg-4 col-md-12">
          <div class="new-news-list">
            <div class="single-default-news latest_video">
              <img src="https://img.youtube.com/vi/{{ $latest_video->video_code }}/0.jpg"
                alt="{{ $latest_video->name }}" style="width: 100%;height:435px;">
              <div class="news-content">
                <h3><a
                    href="https://www.youtube.com/watch?v={{ $latest_video->video_code }}">{{ $latest_video->name }}</a>
                </h3>
              </div>
              <div class="video-btn">
                <a href="https://www.youtube.com/watch?v={{ $latest_video->video_code }}" class="popup-youtube"><i
                    class="icofont-play-alt-3"></i></a>
              </div>
            </div>
          </div>
        </div>
        {{-- <div class="col-lg-3 col-md-12">
          <div class="new-news-list">
            @foreach ($slider3 as $sl)
              @if ($loop->iteration > 10)
                <div class="single-new-news">
                  <img src="{{ $sl->image }}" alt="{{ $sl->title }}"  title='{{ $sl->title }}' class="center" onerror="this.src='{{ $sl->image }}'"/>
                  <div class="news-content">
                    <ul>
                                <li><i class="icofont-calendar"></i> March 22, 2021</li>
                            </ul>
                    <h3><a
                        href="{{ route('news_cat_details', [$sl->getCategory->slug, $sl->slug]) }}">{{ $sl->title }}</a>
                    </h3>
                  </div>
                  <div class="tags bg-3"><a
                      href="{{ route('news_category', $sl->getSubcategory->id == 0 ? $sl->getCategory->slug : $sl->getSubcategory->slug) }}">{{ $sl->getSubcategory->id == 0 ? $sl->getCategory->name : $sl->getSubcategory->name }}</a>
                  </div>
                </div>
              @endif
            @endforeach
          </div>
        </div> --}}
      </div>
    </div>
  </section>
  {{-- news --}}
  <section class="hot-news-area ptb-10">
    <div class="container">
      <div class="col-lg-12 col-md-12">
        <div class="around-the-world-news">
          <div class="section-title">
            <a href="{{ route('news_category', $cat1->slug) }}">
              <h2>{{ __('messages.NEWS') }}</h2>
            </a>
            <a href="#" class="view-more">عرض المزيد <i class="icofont-rounded-double-left"></i></a>
          </div>
          <div class="row">
            @foreach ($news_category as $sl)
              <div class="col-lg-3 col-md-3 desktop_show">
                <div class="single-around-the-world-news">
                  <div class="news-image">
                    <a href="{{ route('news_cat_details', [$sl->getCategory->slug, $sl->slug]) }}"><img
                        src="{{ $sl->image }}" alt="{{ $sl->title }}" title='{{ $sl->title }}' class="center"
                        onerror="this.src='{{ $sl->image }}'" /></a>
                  </div>
                  <div class="news-content">
                    <h3><a
                        href="{{ route('news_cat_details', [$sl->getCategory->slug, $sl->slug]) }}">{{ $sl->title }}</a>
                    </h3>
                  </div>
                </div>
              </div>
            @endforeach
          </div>
          <div class="row mobile_show">
            @foreach ($news_category as $sl)
              @if ($loop->iteration == 1)
                <div class="col-lg-3 col-md-3">
                  <div class="single-around-the-world-news">
                    <div class="news-image">
                      <a href="{{ route('news_cat_details', [$sl->getCategory->slug, $sl->slug]) }}"><img
                          src="{{ $sl->image }}" alt="{{ $sl->title }}" title='{{ $sl->title }}'
                          class="center" onerror="this.src='{{ $sl->image }}'" /></a>
                    </div>
                    <div class="news-content">
                      <h3><a
                          href="{{ route('news_cat_details', [$sl->getCategory->slug, $sl->slug]) }}">{{ $sl->title }}</a>
                      </h3>
                    </div>
                  </div>
                </div>
              @else
                <div class="row subnews_content">
                  <div class="col-4"><img src="{{ $sl->image }}" alt="{{ $sl->title }}"
                      title='{{ $sl->title }}' class="center" onerror="this.src='{{ $sl->image }}'" /></div>
                  <div class="col-8">
                    <div class="content">
                      <h3><a
                          href="{{ route('news_cat_details', [$sl->getCategory->slug, $sl->slug]) }}">{{ $sl->title }}</a>
                      </h3>
                    </div>
                  </div>
                </div>
              @endif
            @endforeach
          </div>
        </div>
      </div>
    </div>
  </section>
  {{-- ads --}}
  {{-- <section class="ptb-10">
    <div class="container">
      <div class="col-lg-12 col-md-12 col">
        <div class="hot-news-ads1">
          <a href="#"><img src="{{ asset('FrontEnd/img/5-ads.png') }}" alt="{{ $sl->title }}"
              style="width: 100%" /></a>
        </div>
      </div>
    </div>
    </div> --}}
    {{-- economy --}}
    <section class="hot-news-area ptb-10">
      <div class="container">
        <div class="col-lg-12 col-md-12">
          <div class="around-the-world-news">
            <div class="section-title">
              <a href="{{ route('news_category', $cat1->slug) }}">
                <h2>{{ $cat1->name }}</h2>
              </a>
              <a href="#" class="view-more">عرض المزيد <i class="icofont-rounded-double-left"></i></a>
            </div>
            <div class="row">
              @foreach ($politics as $sl)
                <div class="col-lg-3 col-md-3 desktop_show">
                  <div class="single-around-the-world-news">
                    <div class="news-image">
                      <a href="{{ route('news_cat_details', [$sl->getCategory->slug, $sl->slug]) }}"><img
                          src="{{ $sl->image }}" alt="{{ $sl->title }}" title='{{ $sl->title }}'
                          class="center" onerror="this.src='{{ $sl->image }}'" /></a>
                    </div>
                    <div class="news-content">
                      <h3><a
                          href="{{ route('news_cat_details', [$sl->getCategory->slug, $sl->slug]) }}">{{ $sl->title }}</a>
                      </h3>
                    </div>
                  </div>
                </div>
              @endforeach
            </div>
            <div class="row mobile_show">
              @foreach ($politics as $sl)
                @if ($loop->iteration == 1)
                  <div class="col-lg-3 col-md-3">
                    <div class="single-around-the-world-news">
                      <div class="news-image">
                        <a href="{{ route('news_cat_details', [$sl->getCategory->slug, $sl->slug]) }}"><img
                            src="{{ $sl->image }}" alt="{{ $sl->title }}" title='{{ $sl->title }}'
                            class="center" onerror="this.src='{{ $sl->image }}'" /></a>
                      </div>
                      <div class="news-content">
                        <h3><a
                            href="{{ route('news_cat_details', [$sl->getCategory->slug, $sl->slug]) }}">{{ $sl->title }}</a>
                        </h3>
                      </div>
                    </div>
                  </div>
                @else
                  <div class="row subnews_content">
                    <div class="col-4"><img src="{{ $sl->image }}" alt="{{ $sl->title }}"
                        title='{{ $sl->title }}' class="center" onerror="this.src='{{ $sl->image }}'" /></div>
                    <div class="col-8">
                      <div class="content">
                        <h3><a
                            href="{{ route('news_cat_details', [$sl->getCategory->slug, $sl->slug]) }}">{{ $sl->title }}</a>
                        </h3>
                      </div>
                    </div>
                  </div>
                @endif
              @endforeach
            </div>
          </div>
        </div>
      </div>
    </section>
    {{-- economy --}}
    {{-- <section class="hot-news-area ptb-10">
    <div class="container">
      <div class="col-lg-12 col-md-12">
        <div class="around-the-world-news">
          <div class="section-title">
            <a href="{{ route('news_category', $cat1->slug) }}">
              <h2>{{ $cat1->name }}</h2>
            </a>
            <a href="{{ route('news_category', $cat1->slug) }}" class="view-more">عرض المزيد <i class="icofont-rounded-double-left"></i></a>
          </div>
          <div class="row">
            @foreach ($politics as $sl)
              <div class="col-lg-3 col-md-3 col-6">
                <div class="single-around-the-world-news-mobile">
                  <div class="news-image">
                    <a href="{{ route('news_cat_details', [$sl->getCategory->slug, $sl->slug]) }}">
                      <img src="{{ $sl->image }}" alt="{{ $sl->title }}"  title='{{ $sl->title }}' class="center" onerror="this.src='{{ $sl->image }}'"/>
                    </a>
                  </div>
                  <div class="news-content">
                    <h3><a href="{{ route('news_cat_details', [$sl->getCategory->slug, $sl->slug]) }}">{{ $sl->title }}</a></h3>
                  </div>
                </div>
              </div>
            @endforeach
          </div>
        </div>
      </div>
    </div>
  </section> --}}
    {{-- video --}}
    <section class="video-news-area ptb-40">
      <div class="container">
        <div class="row">
          <div class="section-title">
            <a href="{{ route('videos_page') }}">
              <h2>{{ __('messages.VIDEOS') }}</h2>
            </a>
          </div>
          @forelse ($videos as $video)
            @if ($loop->iteration == 1)
              <div class="main_video col-lg-6 col-md-6">
                <iframe width="100%" height="415" style="object-fit:cover;"
                  src="https://www.youtube.com/embed/{{ $video->video_code }}" title="{{ $video->name }}"
                  frameborder="0"
                  allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                  allowfullscreen></iframe>
                {{-- <div class="single-default-news">
              <img src="https://img.youtube.com/vi/{{ $video->video_code }}/0.jpg" alt="{{ $video->name }}" style="width: 100%;">
              <div class="news-content">
                <h3><a href="https://www.youtube.com/watch?v={{ $video->video_code }}">{{ $video->name }}</a></h3>
              </div>
              <div class="video-btn">
                <a href="https://www.youtube.com/watch?v={{ $video->video_code }}" class="popup-youtube"><i
                    class="icofont-play-alt-3"></i></a>
              </div>
            </div> --}}
              </div>
              <div class="col-lg-6 col-md-6">

                <div class="row">

                  {{-- <div class="row"> --}}
                @else
                  <div class="col-lg-4 col-md-4 col-6">
                    <div class="media news-media align-items-center">
                      <button class="subvideo" id="{{ $video->video_code . '|' . $video->name }}"
                        style="background: none;border:none;">
                        <img src="https://img.youtube.com/vi/{{ $video->video_code }}/0.jpg"
                          alt="{{ $video->name }}">
                      </button>
                      <div class="subvideo_title content">
                        <h3><button class="subvideo" id="{{ $video->video_code . '|' . $video->name }}"
                            style="background: none;border:none;color:white">{{ $video->name }}</button>
                        </h3>
                      </div>
                    </div>
                  </div>
            @endif

            {{-- </div> --}}
          @empty
          @endforelse
        </div>
      </div>
      </div>
      </div>
    </section>

    {{-- <section class="popular-news-area ptb-20 desktop_show">
    <div class="container">
      <div class="row">
        <div class="col-lg-3 col-md-12">
              <div class="popular-section-ads">
                  <a href="#"><img src="{{ asset('FrontEnd/img/2-ads.png') }}" alt="{{ $polic->title }}" /></a>
              </div>
          </div>
        <div class="col-lg-12 col-md-12">
          <div class="section-title">
            <a href="{{ route('news_category', $cat11->slug) }}">
              <h2>{{ $cat11->name }}</h2>
            </a>
          </div>
          <div class="row">
            <div class="popular-news-slides owl-carousel owl-theme">
              @foreach ($under_almajhar as $polic)
                <div class="col-lg-12 col-md-12">
                  <div class="single-popular-news">
                    <div class="news-image"><img src="{{ $polic->image }}" alt="{{ $polic->title }}"  title='{{ $polic->title }}' class="center" onerror="this.src='{{ $polic->image }}'"/></div>
                    <div class="news-content">
                      <h3>{{ $polic->title }}</h3>
                      <span><i class="icofont-calendar"></i> March 22, 2021</span>
                    </div>
                    <a href="{{ route('news_cat_details', [$polic->getCategory->slug, $polic->slug]) }}"
                      class="link-overlay"></a>
                    <div class="tags bg-{{ $polic->getSubcategory->id }}">
                      <a
                        href="{{ route('news_category', $polic->getSubcategory->id == 0 ? $polic->getCategory->slug : $polic->getSubcategory->slug) }}">{{ $polic->getSubcategory->id == 0 ? $polic->getCategory->name : $polic->getSubcategory->name }}</a>
                    </div>
                  </div>
                </div>
              @endforeach



            </div>
          </div>
        </div>
      </div>
    </div>
  </section> --}}

    {{-- <section class="hot-news-area ptb-10 mobile_show">
    <div class="container">
      <div class="col-lg-12 col-md-12">
        <div class="around-the-world-news">
          <div class="section-title">
            <a href="{{ route('news_category', $cat11->slug) }}">
              <h2>{{ $cat11->name }}</h2>
            </a>
          </div>
          <div class="row">
            @foreach ($under_almajhar as $sl)
                @if ($loop->iteration == 1)
                <div class="col-lg-3 col-md-3">
                  <div class="single-around-the-world-news">
                    <div class="news-image">
                      <a href="{{ route('news_cat_details', [$sl->getCategory->slug, $sl->slug]) }}"><img src="{{ $sl->image }}" alt="{{ $sl->title }}"  title='{{ $sl->title }}' class="center" onerror="this.src='{{ $sl->image }}'"/></a>
                    </div>
                    <div class="news-content">
                      <h3><a href="{{ route('news_cat_details', [$sl->getCategory->slug, $sl->slug]) }}">{{ $sl->title }}</a></h3>
                    </div>
                  </div>
                </div>
                @else
                <div class="col-6">
                  <div class="single-around-the-world-news-mobile">
                    <div class="news-image">
                      <a href="{{ route('news_cat_details', [$sl->getCategory->slug, $sl->slug]) }}"><img src="{{ $sl->image }}" alt="{{ $sl->title }}"  title='{{ $sl->title }}' class="center" onerror="this.src='{{ $sl->image }}'"/></a>
                    </div>
                    <div class="news-content">
                      <h3><a href="{{ route('news_cat_details', [$sl->getCategory->slug, $sl->slug]) }}">{{ $sl->title }}</a></h3>
                    </div>
                  </div>
                </div>
                @endif
            @endforeach
          </div>
        </div>
      </div>
    </div>
  </section> --}}




    {{-- <br style="background-color: #F5F5F5;">
  <section class="hot-news-area pb-40">
    <div class="container">
      <div class="row">
        <div class="col-lg-12 col-md-12">
          <div class="row">
            <div class="col-lg-4 col-md-6">
              <div class="health-lifestyle-news">
                <div class="section-title">
                  <a href="{{ route('news_category', $cat1->slug) }}">
                    <h2>{{ $cat1->name }}</h2>
                  </a>
                </div>
                <div class="health-lifestyle-news-slides owl-carousel owl-theme">
                  @foreach ($local as $lo)
                    <div class="single-health-lifestyle-news">
                      <div class="news-image">
                        <a href="{{ route('news_cat_details', [$lo->getCategory->slug, $lo->slug]) }}"><img
                            src="{{ $lo->image }}" alt="{{ $lo->title }}" /></a>
                      </div>
                      <div class="news-content">
                        <h3><a
                            href="{{ route('news_cat_details', [$lo->getCategory->slug, $lo->slug]) }}">{{ $lo->title }}</a>
                        </h3>
                      </div>
                    </div>
                  @endforeach
                </div>
              </div>
            </div>
            <div class="col-lg-4 col-md-6">
              <div class="politics-news">
                <div class="section-title">
                  <a href="{{ route('news_category', $cat5->slug) }}">
                    <h2>{{ $cat5->name }}</h2>
                  </a>
                </div>
                <div class="politics-news-slides owl-carousel owl-theme">
                  @foreach ($gulf as $lo)
                    <div class="single-health-lifestyle-news">
                      <div class="news-image">
                        <a href="{{ route('news_cat_details', [$lo->getCategory->slug, $lo->slug]) }}"><img
                            src="{{ $lo->image }}" alt="{{ $lo->title }}" /></a>
                      </div>
                      <div class="news-content">
                        <h3><a
                            href="{{ route('news_cat_details', [$lo->getCategory->slug, $lo->slug]) }}">{{ $lo->title }}</a>
                        </h3>
                      </div>
                    </div>
                  @endforeach
                </div>
              </div>
            </div>
            <div class="col-lg-4 col-md-6">
              <div class="politics-news">
                <div class="section-title">
                  <a href="{{ route('news_category', $cat6->slug) }}">
                    <h2>{{ $cat6->name }}</h2>
                  </a>
                </div>
                <div class="politics-news-slides owl-carousel owl-theme">
                  @foreach ($world as $lo)
                    <div class="single-health-lifestyle-news">
                      <div class="news-image">
                        <a href="{{ route('news_cat_details', [$lo->getCategory->slug, $lo->slug]) }}"><img
                            src="{{ $lo->image }}" alt="{{ $lo->title }}" /></a>
                      </div>
                      <div class="news-content">
                        <h3><a
                            href="{{ route('news_cat_details', [$lo->getCategory->slug, $lo->slug]) }}">{{ $lo->title }}</a>
                        </h3>
                      </div>
                    </div>
                  @endforeach
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-lg-12 col-md-12">
          <div class="hot-news-ads2">
            <a href="#"><img src="{{ asset('FrontEnd/img/5-ads.png') }}" alt="{{ $sl->title }}" /></a>
          </div>
        </div>
      </div>
    </div>
  </section> --}}


    {{-- احترامي + مع الأسف --}}
    <section class="all-news-area ptb-20">
      <div class="container">
        <div class="row">
          <div class="col-lg-4 col-md-6">
            <div class="fashion-news">
              <div class="section-title">
                <a href="{{ route('news_category', $cat12->slug) }}">
                  <h2>{{ $cat12->name }}</h2>
                </a>
              </div>
              @foreach ($money as $mo)
                @if ($loop->iteration == 1)
                  <div class="single-fashion-news">
                    <img src="{{ $mo->image }}" alt="{{ $mo->title }}" />
                    <div class="news-content">

                      <h3><a
                          href="{{ route('news_cat_details', [$mo->getCategory->slug, $mo->slug]) }}">{{ $mo->title }}</a>
                      </h3>
                    </div>
                  </div>
                  <div class="fashion-inner-news">
                  @else
                    <div class="single-fashion-inner-news">
                      <h3><a
                          href="{{ route('news_cat_details', [$mo->getCategory->slug, $mo->slug]) }}">{{ $mo->title }}</a>
                      </h3>
                    </div>
                @endif
              @endforeach
            </div>
          </div>
        </div>
        <div class="col-lg-4 col-md-6">
          <div class="food-news">
            <div class="section-title">
              <a href="{{ route('news_category', $cat13->slug) }}">
                <h2>{{ $cat13->name }}</h2>
              </a>
            </div>
            @foreach ($markets as $mo)
              @if ($loop->iteration == 1)
                <div class="single-fashion-news">
                  <img src="{{ $mo->image }}" alt="{{ $mo->title }}" />
                  <div class="news-content">

                    <h3><a
                        href="{{ route('news_cat_details', [$mo->getCategory->slug, $mo->slug]) }}">{{ $mo->title }}</a>
                    </h3>
                  </div>
                </div>
                <div class="fashion-inner-news">
                @else
                  <div class="single-fashion-inner-news">
                    <h3><a href="{{ route('news_cat_details', [$mo->getCategory->slug, $mo->slug]) }}">{{ $mo->title }}</a>
                    </h3>
                  </div>
              @endif
            @endforeach
          </div>
        </div>
      </div>

      {{-- <div class="col-lg-4 col-md-6">
      <div class="north-america-news">
        <div class="section-title">
          <a href="{{ route('news_category', $cat9->slug) }}">
            <h2>{{ $cat9->name }}</h2>
          </a>
        </div>
        @foreach ($real_estate as $mo)
          @if ($loop->iteration == 1)
            <div class="single-fashion-news">
              <img src="{{ $mo->image }}" alt="{{ $mo->title }}" />
              <div class="news-content">
               
                <h3><a
                    href="{{ route('news_cat_details', [$mo->getCategory->slug, $mo->slug]) }}">{{ $mo->title }}</a>
                </h3>
              </div>
            </div>
            <div class="fashion-inner-news">
            @else
              <div class="single-fashion-inner-news">
                <h3><a
                    href="{{ route('news_cat_details', [$mo->getCategory->slug, $mo->slug]) }}">{{ $mo->title }}</a>
                </h3>
              </div>
          @endif
        @endforeach
      </div>
    </div> --}}
      {{-- articles --}}
      <div class="col-lg-4 col-md-6">
        <div class="north-america-news">
          <div class="section-title">
            <a href="{{ route('articles_page') }}">
              <h2>{{ __('messages.ARTICLES') }}</h2>
            </a>
          </div>
          <div class="international-news-inner">
            <div class="row">
              <div class="col-lg-12">
                <div class="international-news-list">
                  @foreach ($articles_all as $article)
                    <div class="news-media articles_block">
                      <a href="{{ route('article_details', $article->slug) }}"> <img
                          src="{{ $article->getWriter->image??'' }}" alt="{{ $article->title }}" /> </a>
                      <div class="content">
                        <span><a
                            href="{{ route('author_details', $article->getWriter->slug??'writer') }}">{{ $article->getWriter->name??'' }}</a></span>
                        <h3><a href="{{ route('article_details', $article->slug) }}">{{ $article->title }}</a></h3>
                      </div>
                    </div>
                  @endforeach
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
      {{-- articles --}}
      </div>

      {{-- <div class="col-lg-12 col-md-12">
      <div class="all-news-ads">
        <a href="#"><img src="{{ asset('FrontEnd/img/5-ads.png') }}" alt="{{ $sl->title }}" /></a>
      </div>
    </div> --}}
      </div>
      </div>
    </section>


    {{-- <section class="international-news-area pb-40" style="background-color: #F5F5F5;">
    <div class="container">
      <div class="row">
        <div class="col-lg-8 col-md-12">
          <div class="col-lg-12 col-md-12">
            <br>
            <div class="section-title">
              <a href="{{ route('news_category', $cat2->slug) }}">
                <h2>{{ $cat2->name }}</h2>
              </a>
            </div>
            <div class="international-news-inner">
              <div class="row">
                @foreach ($economy as $inviro)
                  @if ($loop->iteration == 1)
                    <div class="col-lg-6">
                      <div class="single-international-news">
                        <div class="news-image"><img src="{{ $inviro->image }}" alt="{{ $inviro->title }}"  title='{{ $inviro->title }}' class="center" onerror="this.src='{{ $inviro->image }}'" style="height: 350px;object-fit: cover;" /></div>
                        <div class="news-content">
                          <h3><a
                              href="{{ route('news_cat_details', [$inviro->getCategory->slug, $inviro->slug]) }}">{{ $inviro->title }}</a>
                          </h3>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="international-news-list">
                      @else
                        <span class="sub_economy_news">
                          <div class="media news-media align-items-center">
                            <a href="{{ route('news_cat_details', [$inviro->getCategory->slug, $inviro->slug]) }}">
                              <img src="{{ $inviro->image }}" alt="{{ $inviro->title }}"  title='{{ $inviro->title }}' class="center" onerror="this.src='{{ $inviro->image }}'" /> </a>
                            <div class="content">
                              <h3><a
                                  href="{{ route('news_cat_details', [$inviro->getCategory->slug, $inviro->slug]) }}">{{ $inviro->title }}</a>
                              </h3>
                            </div>
                          </div>
                        </span>
                  @endif
                @endforeach
              </div>
            </div>
          </div>
        </div>
      </div>
      <br>
      <div class="col-lg-12 col-md-12">
        <div class="section-title">
          <a href="{{ route('news_category', $cat3->slug) }}">
            <h2>{{ $cat3->name }}</h2>
          </a>
        </div>
        <div class="international-news-inner">
          <div class="row">
            @foreach ($environment as $inviro)
              @if ($loop->iteration == 1)
                <div class="col-lg-6">
                  <div class="single-international-news">
                    <div class="news-image"><img src="{{ $inviro->image }}" alt="{{ $inviro->title }}"  title='{{ $inviro->title }}' class="center" onerror="this.src='{{ $inviro->image }}'" style="height: 350px;object-fit: cover;" /></div>
                    <div class="news-content">
                      <h3><a
                          href="{{ route('news_cat_details', [$inviro->getCategory->slug, $inviro->slug]) }}">{{ $inviro->title }}</a>
                      </h3>
                    </div>
                  </div>
                </div>
                <div class="col-lg-6">
                  <div class="international-news-list">
                  @else
                  <span class="sub_economy_news">
                    <div class="media news-media align-items-center">
                      <a href="{{ route('news_cat_details', [$inviro->getCategory->slug, $inviro->slug]) }}">
                        <img src="{{ $inviro->image }}" alt="{{ $inviro->title }}"  title='{{ $inviro->title }}' class="center" onerror="this.src='{{ $inviro->image }}'" /> </a>
                      <div class="content">
                        <h3><a
                            href="{{ route('news_cat_details', [$inviro->getCategory->slug, $inviro->slug]) }}">{{ $inviro->title }}</a>
                        </h3>
                      </div>
                    </div>
                  </span>
              @endif
            @endforeach
          </div>
        </div>
      </div>
    </div>
    </div>
    </div>
    <div class="col-lg-4 col-md-6">
      <div class="north-america-news">
        <br>
        <div class="section-title">
          <a href="{{ route('articles_page') }}">
            <h2>{{ __('messages.ARTICLES') }}</h2>
          </a>
        </div>
        <div class="international-news-inner">
          <div class="row">
            <div class="col-lg-12">
              <div class="international-news-list">
                @foreach ($articles_all as $article)
                  <div class="news-media articles_block">
                    <a href="{{ route('article_details', $article->slug) }}"> <img
                        src="{{ $article->getWriter->image }}" alt="{{ $article->title }}" /> </a>
                    <div class="content">
                      <span><a
                          href="{{ route('author_details', $article->getWriter->slug) }}">{{ $article->getWriter->name }}</a></span>
                      <h3><a href="{{ route('article_details', $article->slug) }}">{{ $article->title }}</a></h3>
                    </div>
                  </div>
                @endforeach
              </div>
            </div>
          </div>

        </div>
      </div>
    </div>
    </div>
  </section> --}}
  @endsection
  @push('custom')
    <script>
      $(document).ready(function() {

        $('.subvideo').on('click', function() {
          var video_data = $(this).attr('id').split('|');
          var video_code = video_data[0];
          var video_name = video_data[1];
          $('.main_video').html('<iframe width="100%" height="415" src="https://www.youtube.com/embed/' +
            video_code + '" title="' + video_name +
            '" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>'
          );
          // alert(video_code);
        });
      });
    </script>
  @endpush
