<?=
'<?xml version="1.0" encoding="UTF-8"?>'.PHP_EOL
?>
<rss version="2.0">
    <channel>
        <title>{{ __('messages.SITENAME') }}</title>
        <link>{{ route('feed') }}</link>
        <description>{{ __('messages.SITESLOGAN') }}</description>
        <language>{{ app()->getLocale() }}</language>
        <pubDate>{{ now() }}</pubDate>
  
        @foreach($posts as $post)
            <item>
                <title>{{ $post->title }}</title>
                <link>{{ route('news_cat_details',[$post->getCategory->slug,$post->id]) }}</link>
                <enclosure url='{{ $post->image }}' type='image/jpeg' />
                <description>{{ trim(strip_tags(Str::substr($post->details,0,150))) }}</description>
                <category>{{ $post->getCategory->name }}</category>
                <author>{{ __('messages.URL') }}</author>
                <guid>{{ $post->id }}</guid>
                <pubDate>{{ $post->created_at->toRssString() }}</pubDate>
            </item>
        @endforeach
    </channel>
</rss>