@extends('FrontEnd.Layouts.main')
@section('pagetitle'){{ $news->meta_title==NULL?$news->title:$news->meta_title }} - {{ __('messages.SITENAME') }}@endsection
@section('title'){{ $news->meta_title==NULL?$news->title:$news->meta_title }}@endsection
@section('baseurl'){{ route('news_cat_details', [$news->getCategory->slug, $news->slug]) }}@endsection
@section('logo'){{ $news->image }}@endsection
@section('image'){{ $news->image }}@endsection
@section('keywords'){{ $news->tags }}@endsection
@section('description'){{ $news->meta_description==NULL?htmlspecialchars(trim(strip_tags(Str::substr($news->details, 0, 250)))):$news->meta_description }}@endsection
@section('content')
  @if (Session::has('success'))
    <div class="alert alert-success text-center">
      {{ Session::get('success') }}
    </div>
  @endif
  @if (Session::has('error'))
    <div class="alert alert-danger text-center">
      {{ Session::get('error') }}
    </div>
  @endif
  <section class="news-details-area pb-40">
    <div class="container">
      @include('FrontEnd.Layouts.breadcrumb')
      <div class="row">
        <div class="col-lg-8 col-md-12">
          <div class="news-details">
            
            <div class="article-img">
              <img src="{{ $news->image }}" alt="{{ $news->title }}"  title='{{ $news->title }}' class="center" onerror="this.src='{{ $news->image }}'">
            </div>
            <br>
            <h1>{{ $news->title }}</h1>
            <div class="article-content">
              <ul class="entry-meta">
                <li><i class="icofont-user"></i> <a href="#">{{ $news->source }}</a></li>
                <li><i class="icofont-eye-alt"></i> {{ $news->views }}</li>
                <li><i class="icofont-calendar"></i>
                  {{ $news->created_at->translatedFormat('l') . ' ' . $news->created_at->format('d') . '/' . $news->created_at->translatedFormat('M') . '/' . $news->created_at->format('Y') }}
                </li>-
                <li>{{ __('messages.TIME') }}:
                  {{ $news->created_at->format('g:i') . ' ' . $news->created_at->translatedFormat('A') }}</li>
              </ul>

              {{-- <h2>{{ $news->title }}</h2> --}}

              {!! $news->details !!}
              {!! $shareButtons !!}

              <ul class="category">
                @if ($news->tags == '')
                @else
                  @forelse (explode(',',$news->tags) as $tag)
                    <li><a href="{{ route('newsbytag', $tag) }}">{{ '#' . $tag }}</a></li>
                  @empty
                  @endforelse
                @endif
              </ul>
            </div>
          </div>

          <div class="post-controls-buttons">
            <div>
              {{-- <a href="{{ route('news_cat_details', [$backnews->getCategory->slug,$backnews->id]) }}">{{ __('messages.BACK') }}</a> --}}
            </div>

            <div>
              {{-- <a href="{{ route('news_cat_details', [$nextnews->getCategory->slug,$nextnews->id]) }}">{{ __('messages.NEXT') }}</a> --}}
            </div>
          </div>

          @if ($news->allow_comments == 1)
            <div class="comments-area">
              <h3 class="comments-title">{{ count($news->comments) }} {{ __('messages.COMMENTS') }}:</h3>

              <ol class="comment-list">
                <li class="comment">
                  @forelse ($news->comments as $comment)
                  <article class="comment-body">
                    <footer class="comment-meta">
                      <div class="comment-author vcard">
                        <img src="{{ asset('FrontEnd/img/avatar.jpg') }}" class="avatar" alt="{{ $comment->name }}">
                        <b class="fn"></b>
                      </div>

                      <div class="comment-metadata">
                        <a href="#">
                          <time>{{ $comment->name }}</time>
                        </a>
                      </div>
                    </footer>

                    <div class="comment-content">
                      <p>{{ $comment->comment }}</p>
                    </div>

                    {{-- <div class="reply">
                      <a href="#" class="comment-reply-link">Reply</a>
                    </div> --}}
                  </article>

                  @empty
                    
                  @endforelse
                  
                  {{-- <ol class="children">
                            <li class="comment">
                                <article class="comment-body">
                                    <footer class="comment-meta">
                                        <div class="comment-author vcard">
                                            <img src="assets/img/author1.jpg" class="avatar" alt="image">
                                            <b class="fn">Sinmun</b>
                                            <span class="says">says:</span>
                                        </div>

                                        <div class="comment-metadata">
                                            <a href="#">
                                                <time>April 24, 2021 at 10:59 am</time>
                                            </a>
                                        </div>
                                    </footer>

                                    <div class="comment-content">
                                        <p>Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>
                                    </div>

                                    <div class="reply">
                                        <a href="#" class="comment-reply-link">Reply</a>
                                    </div>
                                </article>
                            </li>
                        </ol> --}}
                </li>


              </ol>

              <div class="comment-respond">
                <h3 class="comment-reply-title">{{ __('messages.ADD_YOUR_COMMENT') }}</h3>

                <form class="comment-form" action="{{ route('send_news_comment') }}" method="post">
                    @csrf
                    <input type="hidden" name="news_id" id="author" value="{{ $news->id }}">
                  <p class="comment-notes">
                    {{-- <span id="email-notes">Your email address will not be published.</span>
                             Required fields are marked 
                            <span class="required">*</span> --}}
                  </p>
                  <p class="comment-form-comment">
                    <label for="comment">{{ __('messages.COMMENT') }}</label>
                    <textarea name="comment" id="comment" cols="45" rows="5" maxlength="65525" required="required"></textarea>
                  </p>
                  <p class="comment-form-author">
                    <label for="name">{{ __('messages.YOUR_NAME') }} <span class="required">*</span></label>
                    <input type="text" id="author" name="name" required="required">
                  </p>
                  <p class="comment-form-email">
                    <label for="email">{{ __('messages.YOUR_EMAIL') }} <span class="required">*</span></label>
                    <input type="email" id="email" name="email" required="required">
                  </p>
                  <p class="comment-form-url">
                    <label for="phone">{{ __('messages.PHONE') }}</label>
                    <input type="number" id="phone" name="phone">
                  </p>
                  {{-- <p class="comment-form-cookies-consent">
                            <input type="checkbox" value="yes" name="wp-comment-cookies-consent" id="wp-comment-cookies-consent">
                            <label for="wp-comment-cookies-consent">Save my name, email, and phone in this browser for the next time I comment.</label>
                        </p> --}}
                  <p class="form-submit">
                    <input type="submit" name="submit" id="submit" class="submit" value="{{ __('messages.SEND') }}">
                  </p>
                </form>
              </div>
            </div>
          @else
          @endif
        </div>

        @include('FrontEnd.Layouts.left')
      </div>
    </div>
  </section>

  <section class="more-news-area">
    <div class="container">
      <div class="more-news-inner">
        <div class="section-title">
          <h2>{{ __('messages.RELATED') }}</h2>
        </div>

        <div class="row">
          <div class="more-news-slides owl-carousel owl-theme">
            @forelse ($related as $rel)
            <div class="col-lg-12 col-md-12">
              <div class="single-more-news">
                <img src="{{ $rel->image }}" alt="{{ $rel->title }}"  title='{{ $rel->title }}' class="center" onerror="this.src='{{ $rel->image }}'">

                <div class="news-content">
                  {{-- <ul>
                    <li><i class="icofont-user-suited"></i> by <a href="#">John Smith</a></li>
                    <li><i class="icofont-calendar"></i> March 22, 2021</li>
                  </ul> --}}
                  <h3><a href="{{ route('news_cat_details', [$rel->getCategory->slug, $rel->slug]) }}">{{ $rel->title }}</a></h3>
                </div>

                {{-- <div class="tags bg-{{ $rel->getCategory->id }}">
                  <a href="{{ route('news_category', $rel->getCategory->slug) }}">{{ $rel->getCategory->name }}</a>
                </div> --}}
              </div>
            </div>
            @empty
            @endforelse
          </div>
        </div>
      </div>
    </div>
  </section>
@endsection
@push('custom')
@endpush
