@extends('FrontEnd.Layouts.main')
@section('pagetitle')
  {{ __('messages.CONTACT') . ' - ' . __('messages.SITENAME') }}
@endsection
@section('title')
  {{ __('messages.CONTACT') }}
@endsection
@section('baseurl')
  {{ route('home') }}
@endsection
@section('logo')
  {{ asset('FrontEnd/imgs/logo.png') }}
@endsection
@section('image')
  {{ asset('FrontEnd/imgs/logo.png') }}
@endsection
@section('description')
  {{ __('messages.SITENAME') . ' | ' . __('messages.SITESLOGAN') }}
@endsection

@section('content')
  @if (Session::has('success'))
    <div class="alert alert-success text-center">
      {{ Session::get('success') }}
    </div>
  @endif
  @if (Session::has('error'))
    <div class="alert alert-danger text-center">
      {{ Session::get('error') }}
    </div>
  @endif
  <section class="contact-area pb-40">
    <div class="container">
      @include('FrontEnd.Layouts.breadcrumb')

      <div class="row">
        <div class="col-lg-8 col-md-12">
          <div class="contact-form">
            <h3>{{ __('messages.SEND_A_MESSAGE') }}</h3>

            <form id="contactUSForm" novalidate="true" action="{{ route('contact_send') }}" method="POST">
              @csrf
              <div class="row">
                <div class="col-lg-4">
                  <div class="form-group">
                    <input type="text" name="name" class="form-control" id="name"
                      placeholder="{{ __('messages.YOUR_NAME') }}*" required="required"
                      data-error="{{ __('messages.YOUR_NAME') }}">
                    @if ($errors->has('name'))
                      <div class="help-block with-errors alert alert-danger">{{ $errors->first('name') }}</div>
                    @endif
                  </div>
                </div>

                <div class="col-lg-4">
                  <div class="form-group">
                    <input type="email" class="form-control" name="email" id="email"
                      placeholder="{{ __('messages.YOUR_EMAIL') }}*" required="required"
                      data-error="{{ __('messages.YOUR_EMAIL') }}">
                      @if ($errors->has('email'))
                      <div class="help-block with-errors alert alert-danger">{{ $errors->first('email') }}</div>
                    @endif
                  </div>
                </div>

                <div class="col-lg-4">
                  <div class="form-group">
                    <input type="text" class="form-control" name="subject" id="msg_subject" required="required"
                      data-error="{{ __('messages.SUBJECT') }}" placeholder="{{ __('messages.SUBJECT') }}*">
                      @if ($errors->has('subject'))
                      <div class="help-block with-errors alert alert-danger">{{ $errors->first('subject') }}</div>
                    @endif
                  </div>
                </div>

                <div class="col-lg-12">
                  <div class="form-group">
                    <textarea placeholder="{{ __('messages.YOUR_MESSAGE') }}*" name="message" id="message" class="form-control"
                      cols="30" rows="10" required="required" data-error="{{ __('messages.YOUR_MESSAGE') }}"></textarea>
                      @if ($errors->has('message'))
                      <div class="help-block with-errors alert alert-danger">{{ $errors->first('message') }}</div>
                    @endif
                  </div>
                </div>

                <div class="col-lg-12">
                   
                  <button type="submit" class="btn btn-primary"
                    style="pointer-events: all; cursor: pointer;">{{ __('messages.SEND') }}</button>
                  <div id="msgSubmit" class="h3 text-center hidden"></div>
                  <div class="clearfix"></div>
                   @if ($errors->has('g-recaptcha-response'))
                        <span class="text-danger">{{ $errors->first('g-recaptcha-response') }}</span>
                    @endif
                </div>
              </div>
            </form>
          </div>
        </div>

        <div class="col-lg-4 col-md-12">
          <div class="contact-info">
            <h3>{{ __('messages.Contact Now') }}</h3>
            <ul>
              {{-- <li><i class="icofont-google-map"></i> 27 name St, city name, country</li> --}}
              {{-- <li><i class="icofont-phone"></i> <a href="tel:+1234567890">+123 456 7890</a></li> --}}
              <li><i class="icofont-envelope"></i> <a href="mailto:info@econewsq8.com">info@econewsq8.com</a></li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </section>
@endsection
@push('custom')
<script src="https://www.google.com/recaptcha/api.js?render={{ env('GOOGLE_RECAPTCHA_KEY') }}"></script>
<script type="text/javascript">
    $('#contactUSForm').submit(function(event) {
        event.preventDefault();
    
        grecaptcha.ready(function() {
            grecaptcha.execute("{{ env('GOOGLE_RECAPTCHA_KEY') }}", {action: 'subscribe_newsletter'}).then(function(token) {
                $('#contactUSForm').prepend('<input type="hidden" name="g-recaptcha-response" value="' + token + '">');
                $('#contactUSForm').unbind('submit').submit();
            });;
        });
    });
</script>
@endpush
