@extends('FrontEnd.Layouts.main')
@section('pagetitle')
  {{ __('messages.ARTICLES') . ' - ' . __('messages.SITENAME') }}
@endsection
@section('title')
  {{ __('messages.ARTICLES') }}
@endsection
@section('baseurl')
  {{ route('home') }}
@endsection
@section('logo')
  {{ asset('FrontEnd/images/logo.png') }}
@endsection
@section('image')
  {{ asset('FrontEnd/images/logo.png') }}
@endsection
@section('description')
  {{ __('messages.SITENAME') . ' | ' . __('messages.SITESLOGAN') }}
@endsection

@section('content')
  @if (Session::has('success'))
    <div class="alert alert-success text-center">
      {{ Session::get('success') }}
    </div>
  @endif
  @if (Session::has('error'))
    <div class="alert alert-danger text-center">
      {{ Session::get('error') }}
    </div>
  @endif
  <section class="author-area pb-40">
    <div class="container">
      @include('FrontEnd.Layouts.breadcrumb')

      {{-- <div class="author-box">
          <img src="assets/img/blogger.jpg" alt="image">

          <div class="author-info">
              <div class="author-title">
                  <h3>{{ $article->getAuthor->name }}</h3>
                  <span><a href="#" target="_blank">http://www.sinmun.com</a></span>
                  <p>Dorem Ipsum is simply dummy text of the printing and typesetting industr been the industry's standard dummy text ever since.</p>
              </div>

              <ul class="post-meta-info">
                  <li><a href="#"><i class="icofont-blogger"></i> 10 Posts</a></li>
                  <li><a href="#"><i class="icofont-comment"></i> 5 Comments</a></li>
              </ul>

              <ul class="social">
                  <li><a href="#" class="facebook"><i class="icofont-facebook"></i></a></li>
                  <li><a href="#" class="twitter"><i class="icofont-twitter"></i></a></li>
                  <li><a href="#" class="linkedin"><i class="icofont-linkedin"></i></a></li>
                  <li><a href="#" class="instagram"><i class="icofont-instagram"></i></a></li>
              </ul>
          </div>
      </div> --}}
    </div>
  </section>
  <section class="all-category-news ptb-40 pt-0">
    <div class="container">
      <div class="row">
        <div class="col-lg-8 col-md-12">
          {{-- <div class="section-title">
                  <h2>All News</h2>
              </div>
               --}}
          @forelse ($articles as $article)
            <div class="single-category-news">
              <div class="row m-0 align-items-center">
                <div class="col-lg-3 col-md-3 p-0">
                  <div class="category-news-image writer_image">
                    <a href="{{ route('article_details', $article->slug) }}">
                      <img src="{{ $article->getWriter->image }}" alt="{{ $article->getWriter->name }}"></a>
                  </div>
                </div>
                <div class="col-lg-9 col-md-9">
                  <div class="category-news-content">
                    <span><a href="{{ route('author_details', $article->getWriter->slug) }}">{{ $article->getWriter->name }}</a></span>
                    <h3><a href="{{ route('article_details', $article->slug) }}">{{ $article->title }}</a></h3>
                  </div>
                </div>
              </div>
            </div>
          @empty
          @endforelse
          <div class="pagination-area">
            {{ $articles->links() }}
            {{-- <a href="#" class="prev page-numbers"><i class="icofont-double-left"></i></a>
                  <a href="#" class="page-numbers">1</a>
                  <span class="page-numbers current" aria-current="page">2</span>
                  <a href="#" class="page-numbers">3</a>
                  <a href="#" class="page-numbers">4</a>
                  <a href="#" class="next page-numbers"><i class="icofont-double-right"></i></a> --}}
          </div>
        </div>

        @include('FrontEnd.Layouts.left')
      </div>
    </div>
  </section>
@endsection
@push('custom')
@endpush
