@extends('FrontEnd.Layouts.main')
@section('pagetitle'){{ $article->meta_title==NULL? $article->meta_title . ' - ' . $article->getWriter->name:$article->meta_title }} | {{ __('messages.SITENAME') }}@endsection
@section('title'){{ $article->meta_title==NULL? $article->meta_title . ' - ' . $article->getWriter->name:$article->meta_title }}@endsection
@section('baseurl'){{ route('article_details', $article->slug) }}@endsection
@section('logo'){{ $article->getWriter->image }}@endsection
@section('image'){{ $article->getWriter->image }}@endsection
@section('keywords'){{ $article->meta_keywords }}@endsection
@section('description'){{ $article->meta_description==NULL? htmlspecialchars(trim(strip_tags(Str::substr($article->details, 0, 180)))):$article->meta_description }}@endsection

@section('content')
  @if (Session::has('success'))
    <div class="alert alert-success text-center">
      {{ Session::get('success') }}
    </div>
  @endif
  @if (Session::has('error'))
    <div class="alert alert-danger text-center">
      {{ Session::get('error') }}
    </div>
  @endif
  <section class="news-details-area pb-40">
    <div class="container">
      @include('FrontEnd.Layouts.breadcrumb')
      <div class="row">
        <div class="col-lg-8 col-md-12 offset-lg-2 offset-md-0">
          <div class="news-details">
            <div class="article-content">
              <div class="row">
                <div class="col-3">
                  <img src="{{ $article->getWriter->image }}" alt="{{ $article->getWriter->name }}"
                    title="{{ $article->getWriter->name }}">
                  <span><a href="{{ route('author_details', $article->getWriter->slug) }}">ارشيف الكاتب</a></span>
                </div>
                <div class="col-9">
                  <ul class="entry-meta">

                    <li><a
                        href="{{ route('author_details', $article->getWriter->slug) }}">{{ $article->getWriter->name }}</a>
                    </li>
                  </ul>
                 
                  <h2 class="mb-0">{{ $article->title }}</h2>
                  <ul class="entry-meta">

                    
                    <li><i class="icofont-eye-alt"></i> {{ $article->views }}</li>
                  </ul>
                </div>
              </div>
            </div>

            <div class="article-img">
              <img src="{{ $article->image }}" alt="{{ $article->title }}"  title='{{ $article->title }}' class="center" onerror="this.src='{{ $article->image }}'">
            </div>

            <div class="article-content">
              {!! $article->details !!}
              {!! $shareButtons !!}

              {{-- <ul class="category">
                          <li><span>Tags:</span></li>
                          <li><a href="#">Business</a></li>
                          <li><a href="#">IT</a></li>
                          <li><a href="#">Tips</a></li>
                          <li><a href="#">Design</a></li>
                      </ul> --}}
            </div>
          </div>

          {{-- <div class="post-controls-buttons">
                  <div>
                      <a href="#">Prev Post</a>
                  </div>

                  <div>
                      <a href="#">Next Post</a>
                  </div>
              </div> --}}
          @if ($article->allow_comments == 1)
            <div class="comments-area">
              <h3 class="comments-title">{{ count($article->comments) }} {{ __('messages.COMMENTS') }}:</h3>

              <ol class="comment-list">
                <li class="comment">
                  @forelse ($article->comments as $comment)
                  <article class="comment-body">
                    <footer class="comment-meta">
                      <div class="comment-author vcard">
                        <img src="{{ asset('FrontEnd/img/avatar.jpg') }}" class="avatar" alt="{{ $comment->name }}">
                        <b class="fn"></b>
                      </div>

                      <div class="comment-metadata">
                        <a href="#">
                          <time>{{ $comment->name }}</time>
                        </a>
                      </div>
                    </footer>

                    <div class="comment-content">
                      <p>{{ $comment->comment }}</p>
                    </div>

                    {{-- <div class="reply">
                      <a href="#" class="comment-reply-link">Reply</a>
                    </div> --}}
                  </article>

                  @empty
                    
                  @endforelse
                  
                  {{-- <ol class="children">
                            <li class="comment">
                                <article class="comment-body">
                                    <footer class="comment-meta">
                                        <div class="comment-author vcard">
                                            <img src="assets/img/author1.jpg" class="avatar" alt="image">
                                            <b class="fn">Sinmun</b>
                                            <span class="says">says:</span>
                                        </div>

                                        <div class="comment-metadata">
                                            <a href="#">
                                                <time>April 24, 2021 at 10:59 am</time>
                                            </a>
                                        </div>
                                    </footer>

                                    <div class="comment-content">
                                        <p>Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>
                                    </div>

                                    <div class="reply">
                                        <a href="#" class="comment-reply-link">Reply</a>
                                    </div>
                                </article>
                            </li>
                        </ol> --}}
                </li>


              </ol>

              <div class="comment-respond">
                <h3 class="comment-reply-title">{{ __('messages.ADD_YOUR_COMMENT') }}</h3>

                <form class="comment-form" action="{{ route('sendcomment') }}" method="post">
                    @csrf
                    <input type="hidden" name="article_id" id="author" value="{{ $article->id }}">
                  <p class="comment-notes">
                    {{-- <span id="email-notes">Your email address will not be published.</span>
                             Required fields are marked 
                            <span class="required">*</span> --}}
                  </p>
                  <p class="comment-form-comment">
                    <label for="comment">{{ __('messages.COMMENT') }}</label>
                    <textarea name="comment" id="comment" cols="45" rows="5" maxlength="65525" required="required"></textarea>
                  </p>
                  <p class="comment-form-author">
                    <label for="name">{{ __('messages.YOUR_NAME') }} <span class="required">*</span></label>
                    <input type="text" id="author" name="name" required="required">
                  </p>
                  <p class="comment-form-email">
                    <label for="email">{{ __('messages.YOUR_EMAIL') }} <span class="required">*</span></label>
                    <input type="email" id="email" name="email" required="required">
                  </p>
                  <p class="comment-form-url">
                    <label for="phone">{{ __('messages.PHONE') }}</label>
                    <input type="number" id="phone" name="phone">
                  </p>
                  {{-- <p class="comment-form-cookies-consent">
                            <input type="checkbox" value="yes" name="wp-comment-cookies-consent" id="wp-comment-cookies-consent">
                            <label for="wp-comment-cookies-consent">Save my name, email, and phone in this browser for the next time I comment.</label>
                        </p> --}}
                  <p class="form-submit">
                    <input type="submit" name="submit" id="submit" class="submit" value="{{ __('messages.SEND') }}">
                  </p>
                </form>
              </div>
            </div>
          @else
          @endif

        </div>
      </div>
      {{-- <div class="author-box">
        <img src="{{ $article->getWriter->image }}" alt="{{ $article->getWriter->name }}">

        <div class="author-info">
            <div class="author-title">
                <h3>{{ $article->getWriter->name }}</h3>
                <span><a href="{{ route('author_details', $article->getWriter->slug) }}">ارشيف الكاتب</a></span>
            </div>

            <ul class="post-meta-info">
                <li><a href="#"> {{ $articles->count() }} مقال</a></li>
            </ul>

            <ul class="social">
              <li><a href="#" class="facebook"><i class="icofont-facebook"></i></a></li>
              <li><a href="#" class="twitter"><i class="icofont-twitter"></i></a></li>
              <li><a href="#" class="instagram"><i class="icofont-instagram"></i></a></li>
              <li><a href="#" class="instagram"><i class="icofont-whatsapp"></i></a></li>
          </ul>
        </div>
    </div> --}}
    </div>
  </section>
  {{-- <section class="more-news-area">
  <div class="container">
      <div class="more-news-inner">
          <div class="section-title">
              <h2>More News</h2>
          </div>

          <div class="row">
              <div class="more-news-slides owl-carousel owl-theme">
                  <div class="col-lg-12 col-md-12">
                      <div class="single-more-news">
                          <img src="assets/img/1.jpg" alt="image">

                          <div class="news-content">
                              <ul>
                                  <li><i class="icofont-user-suited"></i> by <a href="#">John Smith</a></li>
                                  <li><i class="icofont-calendar"></i> March 22, 2021</li>
                              </ul>
                              <h3><a href="#">As well as stopping goals, Cristiane Endler is opening doors.</a></h3>
                          </div>

                          <div class="tags bg-2">
                              <a href="#">Sports</a>
                          </div>
                      </div>
                  </div>

                  <div class="col-lg-12 col-md-12">
                      <div class="single-more-news">
                          <img src="assets/img/2.jpg" alt="image">

                          <div class="news-content">
                              <ul>
                                  <li><i class="icofont-user-suited"></i> by <a href="#">John Smith</a></li>
                                  <li><i class="icofont-calendar"></i> March 22, 2021</li>
                              </ul>
                              <h3><a href="#">As well as stopping goals, Cristiane Endler is opening doors.</a></h3>
                          </div>

                          <div class="tags bg-3">
                              <a href="#">Sports</a>
                          </div>
                      </div>
                  </div>

                  <div class="col-lg-12 col-md-12">
                      <div class="single-more-news">
                          <img src="assets/img/3.jpg" alt="image">

                          <div class="news-content">
                              <ul>
                                  <li><i class="icofont-user-suited"></i> by <a href="#">John Smith</a></li>
                                  <li><i class="icofont-calendar"></i> March 22, 2021</li>
                              </ul>
                              <h3><a href="#">As well as stopping goals, Cristiane Endler is opening doors.</a></h3>
                          </div>

                          <div class="tags bg-4">
                              <a href="#">Sports</a>
                          </div>
                      </div>
                  </div>

                  <div class="col-lg-12 col-md-12">
                      <div class="single-more-news">
                          <img src="assets/img/4.jpg" alt="image">

                          <div class="news-content">
                              <ul>
                                  <li><i class="icofont-user-suited"></i> by <a href="#">John Smith</a></li>
                                  <li><i class="icofont-calendar"></i> March 22, 2021</li>
                              </ul>
                              <h3><a href="#">As well as stopping goals, Cristiane Endler is opening doors.</a></h3>
                          </div>

                          <div class="tags bg-5">
                              <a href="#">Sports</a>
                          </div>
                      </div>
                  </div>
              </div>
          </div>
      </div>
  </div>
</section> --}}
@endsection
@push('custom')
@endpush
