@extends('FrontEnd.Layouts.main')
@section('pagetitle')
  الأرشيف
@endsection

@section('title')
{{  __('messages.SITENAME') }}
@endsection
@section('baseurl')
  {{ route('home') }}
@endsection
@section('logo')
  {{ asset('FrontEnd/images/logo.png') }}
@endsection
@section('image')
  {{ asset('FrontEnd/images/logo.png') }}
@endsection
@section('description')
  {{ __('messages.SITENAME') . ' | ' . __('messages.SITESLOGAN') }}
@endsection


@section('content')

  <section class="news-details-area pb-40">
    <div class="container">
      @include('FrontEnd.Layouts.breadcrumb')
      <ul class="breadcrumb">
        <li><a href="{{ route('home') }}"><i class="icofont-home"></i> {{ __('messages.HOME') }}</a></li>
        <li><i class="icofont-rounded-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }}"></i></li>
        <li><a href="{{ route('pdf_all') }}">الأرشيف</a></li>
        <li><i class="icofont-rounded-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }}"></i></li>
        <li>@yield('title')</li>
      </ul>
      <div class="row">
        <div class="col-lg-12 col-md-12 offset-lg-2 offset-md-0">
          <div class="news-details">
            <div class="article-content">
              <div class="row">
                  @foreach($pdfs as $pdf)
                    <div class="col-lg-3">
                        <a href="{{asset('upload/pdf/'.$pdf->pdf)}}" class="btn btn-primary" download target="_blank">{{$pdf->name}}</a>
                    </div>
                  @endforeach
              </div>
            </div>
          </div>
        </div>
      </div>
   </div>
  </section>

@endsection
@push('custom')
@endpush
