@extends('FrontEnd.Layouts.main')
@section('pagetitle')
  {{  __('messages.SITENAME') }}
@endsection
@section('title')
{{  __('messages.SITENAME') }}
@endsection
@section('baseurl')
  {{ route('home') }}
@endsection
@section('logo')
  {{ asset('FrontEnd/images/logo.png') }}
@endsection
@section('image')
  {{ asset('FrontEnd/images/logo.png') }}
@endsection
@section('description')
  {{ __('messages.SITENAME') . ' | ' . __('messages.SITESLOGAN') }}
@endsection
@section('content')
@if(session('success'))
<div class="alert alert-success text-center">
  {{session("success")}}
</div>
@endif
@if(session('error'))
<div class="alert alert-danger text-center">
  {{ session('error') }}
</div>
@endif
<section class="all-category-news ptb-40 pt-0">
  <div class="container">
    @include('FrontEnd.Layouts.breadcrumb')
      <div class="row">
          <div class="col-lg-8 col-md-12">
              {{-- <div class="section-title">
                  <h2>{{ $category->name_ar }}</h2>
              </div> --}}
              @forelse ($allnews as $news)
              <div class="single-category-news">
                <div class="row m-0 align-items-center">
                    <div class="col-lg-5 col-md-6 p-0">
                        <div class="category-news-image">
                              <img src="{{ $news->getRawOriginal('image') }}" alt="{{ $news->title }}"  title='{{ $news->title }}' class="center" onerror="this.src='{{ $news->getRawOriginal('image') }}'">

                            {{-- <div class="tags">
                                <a href="#">Sports</a>
                            </div> --}}
                        </div>
                    </div>

                    <div class="col-lg-7 col-md-6">
                        <div class="category-news-content">
                            <p>{{ $news->getRawOriginal('image') }}</p>
                        </div>
                    </div>
                </div>
            </div>
              @empty
                  
              @endforelse
              

              

              <div class="pagination-area">
                {{-- {{ $newsbycategory->links() }} --}}
                  {{-- <a href="#" class="prev page-numbers"><i class="icofont-double-left"></i></a>
                  <a href="#" class="page-numbers">1</a>
                  <span class="page-numbers current" aria-current="page">2</span>
                  <a href="#" class="page-numbers">3</a>
                  <a href="#" class="page-numbers">4</a>
                  <a href="#" class="next page-numbers"><i class="icofont-double-right"></i></a> --}}
              </div>
          </div>

          {{-- @include('FrontEnd.Layouts.left') --}}
      </div>
  </div>
</section>
@endsection
@push('custome')
@endpush