<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}" dir="{{ app()->getLocale() == 'ar' ? 'rtl' : 'ltr' }}">
<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="baseUrl:" content="@yield('baseurl')">
  <meta name="title" content="@yield('pagetitle', __('messages.SITENAME'))">
  <meta http-equiv='content-type' content='text/html; charset=utf-8' />
  <meta name="ROBOTS" content="INDEX,FOLLOW,all">
  <meta name='language' content='ar' />
  <meta name='audience' content='all' />
  <meta name='rating' content='general' />
  <meta name='revisit' content='1days' />
  <meta name='revisit-after' content='1days' />
  <meta name='resource-type' content='document' />
  <meta name='googlebot' content='index, follow, ydir, odp, imageindex' />
  <meta name='slurp' content='index, follow, ydir, odp, archive' />
  <meta name='resource-type' content='document' />
  <meta name="description" content="@yield('description')">
  <meta name="logo:" content="@yield('logo')">
  <meta name="image:" content="@yield('image')">
  <meta name="keywords" content="@yield('keywords')">
  <meta name="author" content="{{ __('messages.SITENAME') }}">
  <meta name="publisher" content="{{ __('messages.SITENAME') }}">
  <meta name="type:" content="HTML,CSS,bootstrap">
  <meta name="copyright" content="{{ __('messages.URL') }}">
  <meta http-equiv='X-UA-Compatible' content='IE=edge' />
  <meta http-equiv='X-UA-Compatible' content='IE=EmulateIE7' />
  {{-- Facebook --}}
  <meta property="og:title" content="@yield('pagetitle', __('messages.SITENAME'))" />
  <meta property="og:type" content="HTML,CSS,bootstrap" />
  <meta property="og:image" content="@yield('image')" />
  <meta property="og:image:alt" content="@yield('pagetitle', __('messages.SITENAME'))" />
  <meta property="og:url" content="@yield('baseurl')" />
  <meta property="og:locale" content="ar" />
  <meta property="og:site_name" content="{{ __('messages.SITENAME') . ' | ' . __('messages.SITESLOGAN') }}">
  <meta property="og:description" content="@yield('description')">
  {{-- twitter --}}
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:creator" content="@yield('twitter')" />
  <meta name="twitter:description" content="@yield('description')" />
  <meta name="twitter:image:alt" content="@yield('pagetitle', __('messages.SITENAME'))" />
  <meta name="twitter:image:src" content="@yield('image')" />
  <meta name="twitter:site" content="@yield('twitter')" />
  <meta name="twitter:title" content="@yield('pagetitle', __('messages.SITENAME'))" />
  <title>@yield('pagetitle', __('messages.SITENAME'))</title>
  <link rel="canonical" href="@yield('baseurl')" />
  <link rel="stylesheet" href="{{ asset('FrontEnd/css/bootstrap.rtl.min.css') }}" />
  <link rel="stylesheet" href="{{ asset('FrontEnd/css/animate.min.css') }}" />
  <link rel="stylesheet" href="{{ asset('FrontEnd/css/icofont.min.css') }}" />
  <link rel="stylesheet" href="{{ asset('FrontEnd/css/meanmenu.css') }}" />
  <link rel="stylesheet" href="{{ asset('FrontEnd/css/owl.carousel.min.css') }}" />
  <link rel="stylesheet" href="{{ asset('FrontEnd/css/magnific-popup.min.css') }}" />
  <link rel="stylesheet" href="{{ asset('FrontEnd/css/style.css') }}" />
  <link rel="stylesheet" href="{{ asset('FrontEnd/css/dark.css') }}" />
  @if (app()->getLocale() == 'ar')
    <link rel="stylesheet" href="{{ asset('FrontEnd/css/rtl.css') }}">
  @endif
  <link rel="stylesheet" href="{{ asset('FrontEnd/css/responsive.css') }}" />
  <link rel="stylesheet" href="{{ asset('FrontEnd/css/ent-styles.css') }}">
  <link rel="stylesheet" href="{{ asset('FrontEnd/css/customzz.css') }}" />
  <link rel="stylesheet" href="{{ asset('FrontEnd/css/breaking-news-ticker.css') }}">
  <link rel="icon" type="image/png" href="{{ asset('FrontEnd/img/favicon.png') }}" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css"/>
  <link rel="stylesheet" href="{{ asset('FrontEnd/css/social.css') }}" />
</head>
<body>

  @include('FrontEnd.Layouts.header')
  @yield('content')
  @include('FrontEnd.Layouts.footer')
  @include('FrontEnd.Layouts.ticker')
  
  <div class="go-top"><i class="icofont-swoosh-up"></i></div>

  <script src="{{ asset('FrontEnd/js/jquery.min.js') }}"></script>
  <script src="{{ asset('FrontEnd/js/bootstrap.bundle.min.js') }}"></script>
  <script src="{{ asset('FrontEnd/js/jquery.meanmenu.js') }}"></script>
  <script src="{{ asset('FrontEnd/js/mixitup.min.js') }}"></script>
  <script src="{{ asset('FrontEnd/js/owl.carousel.min.js') }}"></script>
  <script src="{{ asset('FrontEnd/js/jquery.magnific-popup.min.js') }}"></script>
  <script src="{{ asset('FrontEnd/js/form-validator.min.js') }}"></script>
  <script src="{{ asset('FrontEnd/js/contact-form-script.js') }}"></script>
  <script src="{{ asset('FrontEnd/js/jquery.ajaxchimp.min.js') }}"></script>
  <script src="{{ asset('FrontEnd/js/main.js') }}"></script>
  <script src="{{ asset('FrontEnd/js/jquery-3.6.0.min.js') }}"></script>
  <script src="{{ asset('FrontEnd/js/jquery-3.3.1.min.js') }}"></script>
  <script src="{{ asset('FrontEnd/js/webfont.js') }}"></script>
  <script src="{{ asset('FrontEnd/js/ent-scripts.min.js') }}"></script>
  <script src="{{ asset('FrontEnd/js/script.js') }}" referrerpolicy="no-referrer"></script>
  <script src="https://kit.fontawesome.com/8c73d8862b.js" crossorigin="anonymous"></script>
  <script src="{{ asset('FrontEnd/js/ticker.js') }}"></script>
  <script>
    $(document).ready(function() {
      // openLoginModal();
      $('#your_email').on('click', function() {
        alert('email');
      });
    });
    $('#newsTicker15').breakingNews({
      position: 'fixed-bottom',
      borderWidth: 3,
      height: 50,
      // themeColor: 'rgb(2, 126, 122)',
      direction: 'rtl'
    });
  </script>
  <script>
    window._2chatConfig = {
    phoneNumber:'+9651808082',
    accountName: `مرحبا `,
    statusMessage: سوف نتواصل معك خلال ٥ دقائق,
    chatMessage: `شكراً لتواصلك مع جريدة ايكونيوز الاقتصادية ب الو 80
 الاعلامية

لخدمتك يرجى الاختيار من القائمة التالية :
1️⃣للاشتراك لتصلك الجريدة بالواتس اب
2️⃣للاعلان
3️⃣لتحديث بياناتك
ــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــ
شكراً لتواصلك معنا`,
    placeholder: 'اكتب رسالتك...',
    position: 'right',
    colorScheme: 'automatic',
    showNotification: true,
  };

  (function(d, s, id) {
    var js, fjs = d.getElementsByTagName(s)[0];
    if (d.getElementById(id)) return; 
    js = d.createElement(s); js.id = id;
    js.src = 'https://widgets.2chat.io/index.js';
    fjs.parentNode.insertBefore(js, fjs);
  }(document, 'script', '_2chat'));
</script>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-PGG3L4Q6');</script>
<!-- End Google Tag Manager -->
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-PGG3L4Q6"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
  @stack('custom')
</body>

</html>
