<ul class="breadcrumb">
  <li><a href="{{ route('home') }}"><i class="icofont-home"></i> {{ __('messages.HOME') }}</a></li>

  @if (Request::segment(3) == 'news')

    <li><i class="icofont-rounded-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }}"></i></li>
    <li><a href="{{ route('news_category', $category->slug) }}">{{ $category->name }}</a></li>
    <li><i class="icofont-rounded-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }}"></i></li>
    <li>{{ $news->title }}</li>
  @elseif (Request::segment(1) == 'articles')
    <li><i class="icofont-rounded-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }}"></i></li>
    <li>{{ __('messages.ARTICLES') }}</li>
  @elseif (Request::segment(1) == 'article')
    <li><i class="icofont-rounded-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }}"></i></li>
    <li><a href="{{ route('articles_page') }}">{{ __('messages.ARTICLES') }}</a></li>
    <li><i class="icofont-rounded-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }}"></i></li>
    <li>{{ $article->title }} <span style="font-size: smaller;"> - {{ $article->getWriter->name }}</span></li>
  @elseif (Request::segment(1) == 'author')
    <li><i class="icofont-rounded-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }}"></i></li>
    <li><a href="{{ route('articles_page') }}">{{ __('messages.ARTICLES') }}</a></li>
    <li><i class="icofont-rounded-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }}"></i></li>
    <li>{{ $writer->name }}</li>
 
  @elseif (Request::segment(1) == 'photos' && count(Request::segments()) < 2)
    <li><i class="icofont-rounded-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }}"></i></li>
    <li>{{ __('messages.PHOTOS') }}</li>
  @elseif (Request::segment(2) == 'album' && count(Request::segments()) > 1)
    <li><i class="icofont-rounded-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }}"></i></li>
    @if (Request::segment(1) == 'photos')
      <li><a href="{{ route('photos_page') }}">{{ __('messages.PHOTOS') }}</a></li>
    @elseif (Request::segment(1) == 'infographic')
      <li><a href="{{ route('infographic_page') }}">{{ __('messages.INFOGRAPHIC') }}</a></li>
    @elseif (Request::segment(1) == 'comic')
      <li><a href="{{ route('comic_page') }}">{{ __('messages.Comics') }}</a></li>
    @elseif (Request::segment(1) == 'podcast')
      <li><a href="{{ route('podcast_page') }}">{{ __('messages.Podcast') }}</a></li>
    @elseif (Request::segment(1) == 'videos')
      <li><a href="{{ route('videos_page') }}">{{ __('messages.VIDEOS') }}</a></li>
    @endif
    <li><i class="icofont-rounded-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }}"></i></li>
    <li>{{ $title }}</li>
  @elseif (Request::segment(1) == 'pages')
    <li><i class="icofont-rounded-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }}"></i></li>
    <li>{{ $page->name }}</li>
  @elseif (Request::segment(1) == 'cat')
    <li><i class="icofont-rounded-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }}"></i></li>
    <li>{{ $category->name }}</li>
  @else
    <li><i class="icofont-rounded-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }}"></i></li>
    <li>@yield('title')</li>

  @endif
</ul>
