@extends('BackEnd.Layouts.main')
@section('title')
{{ __('messages.Add Video') }}
@endsection

@section('content')

<section class="content">
  <div class="container-fluid">
    @include('BackEnd.Layouts.breadcrumb')
      @if(session('success'))
      <div class="alert alert-success text-center">
        {{session("success")}}
      </div>
      @endif
      @if(session('error'))
      <div class="alert alert-danger text-center">
        {{ session('error') }}
      </div>
      @endif

    <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
          @include('BackEnd.Layouts.tableheader')
          <div class="body">
            <form id="form_validation" method="POST" action="{{ route('videos.store') }}" enctype="multipart/form-data">
              @csrf
              <div class="row">
                <div class="col-md-8">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="name" value="{{ old('name') }}" required>
                      <label class="form-label">{{ __('messages.TITLE') }}</label>
                      @if ($errors->has('name'))
                      <label class="alert alert-danger">{{ $errors->first('name') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-md-2">
                  <p>
                    <b>النوع</b>
                  </p>
                  <div class="form-group default-select select2Style">
                    <select class="form-control select2" id="type" name="type" data-placeholder="الفئة الرئيسية"
                      required>
                      <option value="">اختر من القائمة</option>
                      {{-- <option value="photos" {{ Session::get('type') == 'photos' ? 'selected' : '' }}>البوم صور</option> --}}
                      {{-- <option value="interactive_stories" {{ Session::get('type') == 'interactive_stories' ? 'selected' : '' }}>قصص تفاعلية</option> --}}
                      {{-- <option value="comic" {{ Session::get('type') == 'comic' ? 'selected' : '' }}>كوميكس</option> --}}
                      {{-- <option value="infographic" {{ Session::get('type') == 'infographic' ? 'selected' : '' }}>انفوجراف</option> --}}
                      <option value="podcast" {{ Session::get('type') == 'podcast' ? 'selected' : '' }}>بودكاست</option>
                      <option value="videos" {{ Session::get('type') == 'videos' ? 'selected' : '' }}>فيديو</option>
                    </select>
                  </div>
                </div>
                <div class="col-md-2">
                  <p>
                    <b>الالبوم</b>
                  </p>
                  <div class="form-group default-select select2Style">
                    <select class="form-control select2" id="category_id" name="category_id" data-placeholder="Select" required>
                      <option value="">اختر النوع أولاً</option>
                    </select>
                  </div>
                </div>
               

                {{-- <div class="col-md-6">
                  <div class="form-group form-float">
                  <div class="form-line">
                    <input type="text" class="form-control" name="details_ar" value="{{ old('details_ar') }}" required>
                    <label class="form-label">{{ __('messages.Ad text') }} ({{ __('messages.ARABIC') }})</label>
                      @if ($errors->has('details_ar'))
                      <label class="alert alert-danger">{{ $errors->first('details_ar') }}</label>
                      @endif
                  </div>
                </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="details_en" value="{{ old('details_en') }}" required>
                      <label class="form-label">{{ __('messages.Ad text') }} ({{ __('messages.ENGLISH') }})</label>
                      @if ($errors->has('details_en'))
                      <label class="alert alert-danger">{{ $errors->first('details_en') }}</label>
                      @endif
                    </div>
                  </div>
                </div> --}}
                
                <div class="col-md-12">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="videocode" value="{{ old('url') }}" required>
                      <label class="form-label">{{ __('messages.Video Url') }}</label>
                      @if ($errors->has('url'))
                      <label class="alert alert-danger">{{ $errors->first('url') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="form-group">
                  <div class="form-check m-l-10">
                    <label class="form-check-label">
                      <input class="form-check-input" type="checkbox" id="checkbox" name="is_active" checked>
                      {{ __('messages.PUBLISHED') }}
                      <span class="form-check-sign">
                        <span class="check"></span>
                      </span>
                    </label>
                  </div>
                </div>
                <button class="btn btn-primary waves-effect" type="submit">{{ __('messages.Add') }}</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>


  </div>
</section>



@endsection
@push('plugin_js')
  <script src="{{ asset('BackEnd/js/form.min.js') }}"></script>
  <script src="{{ asset('BackEnd/js/bundles/multiselect/js/jquery.multi-select.js') }}"></script>
  <script src="{{ asset('BackEnd/js/bundles/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.js') }}"></script>
@endpush
@push('custom_js')
  <script src="{{ asset('BackEnd/js/pages/forms/basic-form-elements.js') }}"></script>
  <script src="{{ asset('BackEnd/js/pages/forms/advanced-form-elements.js') }}"></script>
  <script>
    $(document).ready(function() {
      $('#type').on('change', function() {
        $('#category_id').empty();
        $.getJSON("/eco_panel/get_album/" + $(this).val(), function(data) {
          $('#category_id').show();
          // $('#category_id').html('<option value="0">رئيسي</option>');
          $.each(data, function(index, item) {
            $('#category_id').append(
              $('<option></option>').val(item["id"]).html(item["name"])
            );
          });
        });
      });
    });
  </script>
@endpush
