@extends('BackEnd.Layouts.main')
@section('title')
  {{ __('messages.View Categories') }}
@endsection
@section('content')
  <section class="content">
    <div class="container-fluid">
      @include('BackEnd.Layouts.breadcrumb')
      @if (session('success'))
        <div class="alert alert-success text-center">
          {{ session('success') }}
        </div>
      @endif
      @if (session('error'))
        <div class="alert alert-danger text-center">
          {{ session('error') }}
        </div>
      @endif

      <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
          <div class="card">
            @include('BackEnd.Layouts.tableheader')
            <div class="body">
              {{-- album type --}}
              <div class="dt-buttons">
                <div class="row">
                  @php
                    Session::put('type', Request::segment(3));
                  @endphp
                  {{-- <a href="{{ route('photo_categories.index','photos') }}" class="dt-button buttons-{{ Request::segment(3)=='photos'?'pdf':(count(Request::segments())<3?'pdf':'print') }}" style="width:150px;text-align:center;padding:3px;">
                    <span>البوم صور </span>
                  </a>
                  <a href="{{ route('photo_categories.index','interactive_stories') }}" class="dt-button buttons-{{ Request::segment(3)=='interactive_stories'?'pdf':'print' }}" style="width:150px;text-align:center;padding:3px;">
                    <span>قصص تفاعلية</span>
                  </a>
                  <a href="{{ route('photo_categories.index','comic') }}" class="dt-button buttons-{{ Request::segment(3)=='comic'?'pdf':'print' }}" style="width:150px;text-align:center;padding:3px;">
                    <span>كوميكس</span>
                  </a>
                  <a href="{{ route('photo_categories.index','infographic') }}" class="dt-button buttons-{{ Request::segment(3)=='infographic'?'pdf':'print' }}" style="width:150px;text-align:center;padding:3px;">
                    <span>انفوجراف</span>
                  </a> --}}
                  <a href="{{ route('video_categories.index', 'podcast') }}"
                    class="dt-button buttons-{{ Request::segment(3) == 'podcast' ? 'pdf' : 'print' }}"
                    style="width:150px;text-align:center;padding:3px;">
                    <span>بودكاست</span>
                  </a>
                  <a href="{{ route('video_categories.index', 'videos') }}"
                    class="dt-button buttons-{{ Request::segment(3) == 'videos' ? 'pdf' : 'print' }}"
                    style="width:150px;text-align:center;padding:3px;">
                    <span>فيديو</span>
                  </a>

                  {{-- @foreach ($categories as $cats)
                        <a href="#"
                          class="dt-button buttons-{{ $cats->id==Request::segment(3)?'pdf':'print' }}"
                          style="width:150px;text-align:center;padding:3px;">
                          <span>{{ $cats->type }}</span>
                        </a>
                  @endforeach --}}
                </div>
              </div>
              {{-- album type --}}
              <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover save-stage dataTable" style="width:100%;">
                  <thead>
                    <tr>
                      <th>م</th>
                      <th>اسم الالبوم</th>
                      <th>الصورة</th>
                      <th>النوع</th>
                      <th>عدد {{ __('messages.' . strtoupper(Session::get('type'))) }}</th>
                      {{-- @ability(['admin','super_admin'],['']) --}}
                      <th>الحالة</th>
                      {{-- @endability --}}
                      <th>تاريخ الإضافة</th>
                      <th>الناشر</th>
                      <th>آخر تعديل بواسطة</th>
                      <th>{{ __('messages.CONTROL') }}</th>
                    </tr>
                  </thead>
                  <tbody>
                    @foreach ($categories as $category)
                      <tr id="{{ $category->id }}">
                        <td>{{ $loop->iteration }}</td>
                        <td><a href="{{ route('home') }}"
                            style="font-weight: 700;">{{ $category->parent_id > 0 ? '--' : '' }}
                            {{ $category->name_ar }}</a></td>
                        <td><img src="{{ $category->image }}" alt="" style="height: 100px"></td>
                        <td>{{ __('messages.' . strtoupper($category->type)) }}</td>
                        @if (Request::segment(3) == 'videos' || Request::segment(3) == 'podcast')
                          <td>{{ $category->photos->count() ?? 0 }}</td>
                        @else
                          <td>{{ $category->photos->count() ?? 0 }}</td>
                        @endif

                        {{-- @ability(['admin','super_admin'],['']) --}}
                        <td><button type="button" id="{{ $category->id }}"
                            class="is_active btn btn-outline-{{ $category->is_active == 1 ? 'success' : 'warning' }} btn-border-radius"><span
                              id="span-{{ $category->id }}">{{ $category->is_active == 1 ? __('messages.PUBLISHED') : __('messages.UNPUBLISHED') }}</span></button>
                        </td>
                        {{-- @endability --}}
                        <td><span style="font-size:xx-small">
                            {{ $category->created_at->toDateString() }}</span><br>
                          {{ $category->created_at->toTimeString() }}</td>
                        <td>{{ $category->getUser->name ?? '' }}</td>
                        <td>{{ $category->getEditor->name ?? '' }}</td>
                        <td>

                          <a href="{{ route('video_categories.edit', $category->id) }}" style="color: white"><button
                              type="button" class="btn btn-info btn-circle waves-effect waves-circle waves-float">
                              <i class="material-icons">mode_edit</i></a>
                          </button>
                          {{-- @ability(['publisher','admin','super_admin'],['']) --}}
                          @if (true)
                            <button type="button"
                              class="delete btn btn-danger btn-circle waves-effect waves-circle waves-float"
                              id="{{ $category->id . ',' . $category->name_ar . ',' . __('messages.Are you sure you want to delete the row named:') }}">
                              <i class="material-icons">delete_forever</i>
                            </button>
                          @endif
                          {{-- @endability --}}
                        </td>
                      </tr>
                      @foreach ($subcategories as $subcategory)
                        @if ($subcategory->parent_id == $category->id)
                          <tr id="{{ $subcategory->id }}">
                            <td>{{ $loop->iteration }}</td>
                            <td><a href="{{ route('home') }}">{{ $subcategory->parent_id > 0 ? '--' : '' }}
                                {{ $subcategory->name_ar }}</a></td>
                            <td><img src="{{ $category->image }}" alt="" style="height: 100px"></td>
                            <td>{{ __('messages.' . strtoupper($category->type)) }}</td>
                            @if (Request::segment(3) == 'videos' || Request::segment(3) == 'podcast')
                              <td>{{ $subcategory->videos->count() ?? 0 }}</td>
                            @else
                              <td>{{ $subcategory->videos->count() ?? 0 }}</td>
                            @endif
                            {{-- @ability(['admin','super_admin'],['']) --}}
                            <td><button type="button" id="{{ $subcategory->id }}"
                                class="is_active btn btn-outline-{{ $subcategory->is_active == 1 ? 'success' : 'warning' }} btn-border-radius"><span
                                  id="span-{{ $subcategory->id }}">{{ $subcategory->is_active == 1 ? __('messages.PUBLISHED') : __('messages.UNPUBLISHED') }}</span></button>
                            </td>
                            {{-- @endability --}}
                            <td><span style="font-size:xx-small">
                                {{ $subcategory->created_at->toDateString() }}</span><br>
                              {{ $subcategory->created_at->toTimeString() }}</td>
                            <td>{{ $subcategory->getUser->name ?? '' }}</td>
                            <td>{{ $subcategory->getEditor->name ?? '' }}</td>
                            <td>

                              <a href="{{ route('categories.edit', $subcategory->id) }}" style="color: white"><button
                                  type="button" class="btn btn-info btn-circle waves-effect waves-circle waves-float">
                                  <i class="material-icons">mode_edit</i></a>
                              </button>
                              {{-- @ability(['publisher','admin','super_admin'],['']) --}}
                              @if (true)
                                <button type="button"
                                  class="delete btn btn-danger btn-circle waves-effect waves-circle waves-float"
                                  id="{{ $subcategory->id . ',' . $subcategory->name_ar . ',' . __('messages.Are you sure you want to delete the row named:') }}">
                                  <i class="material-icons">delete_forever</i>
                                </button>
                              @endif
                              {{-- @endability --}}
                            </td>
                          </tr>
                        @endif
                      @endforeach
                    @endforeach
                  </tbody>
                </table>
                {{ $categories->links() }}
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">{{ __('messages.Confirm Deletion') }}</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body" id='modal_content'>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-info waves-effect" id="delete_btn">{{ __('messages.YES') }}</button>
          {{-- <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal">{{ __('messages.NO') }}</button> --}}
        </div>
      </div>
    </div>
  </div>
@endsection
@push('plugin_js')
  <script src="{{ asset('BackEnd/js/table.min.js') }}"></script>
@endpush
@push('custom_js')
  {{-- <script src="{{ asset('BackEnd/js/pages/tables/jquery-datatable.js') }}"></script> --}}
@endpush

@push('is_active_ajax')
  <script>
    $(document).ready(function() {
      $('.is_active').on('click', function() {
        var $category_id = $(this).attr('id');
        // alert($category_id);
        $.getJSON("/eco_panel/video_categories/status/" + $category_id, function(data) {
          $.each(data, function(index, item) {
            if (item == 1)
              $('#span-' + $category_id).html('<span style="color:#29b474">منشور</span>');
            if (item == -1)
              $('#span-' + $category_id).html('<span style="color:#eb5757">غير منشور</span>');
          });
        });
      });

      var del;
      $('.delete').on('click', function() {
        del = $(this).attr('id').split(',');
        // alert(del[0]);
        // alert(del[1]);
        // alert(del[2]);
        $('#deleteModal').modal('show');
        $('#modal_content').html(del[2] + "<br>\
            <p class='alert alert-warning modal__text'>" + del[1] + " </p>");
        $('.modal__btns').show();
      });
      $('#delete_btn').on('click', function() {
        $.getJSON("/eco_panel/video_categories/delete/" + del[0], function(data) {
          if (data == 0) {
            $('#modal_content').html(
              "<p class='alert alert-danger'> لا يمكن حذف الالبوم لوجود صور مرتبطة <p>");
            $('.modal__btns').hide();
            // $('#deleteModal').modal('toggle');
          } else {
            $('#modal_content').html("<p class='alert alert-warning'> تم الحذف بنجاح <p>");
            $('.modal__btns').hide();
            $('#deleteModal').modal('toggle');
            $('#' + del[0] + '').fadeOut(1500);
          }

        });
      });
    });
  </script>
@endpush
