@extends('BackEnd.Layouts.main')
@section('title')
{{ __('messages.View Users') }}
@endsection
@section('content')

<section class="content">
  <div class="container-fluid">
    @include('BackEnd.Layouts.breadcrumb')
      @if(session('success'))
      <div class="alert alert-success text-center">
        {{session("success")}}
      </div>
      @endif
      @if(session('error'))
      <div class="alert alert-danger text-center">
        {{ session('error') }}
      </div>
      @endif

    <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
          @include('BackEnd.Layouts.tableheader')
          <div class="body">
            <div class="table-responsive">
              <table class="table table-bordered table-striped table-hover save-stage dataTable" style="width:100%;">
                <thead>
                  <tr>
                    <th>م</th>
                    <th>{{ __('messages.NAME') }}</th>
                    <th>{{ __('messages.EMAIL') }}</th>
                    <th>الصلاحيات</th>
                    {{-- @ability(['admin','super_admin'],['']) --}}
                    <th>{{ __('messages.STATUS') }}</th>
                    {{-- @endability --}}
                    <th>{{ __('messages.PUBLISHED_DATE') }}</th>
                    <th>{{ __('messages.CONTROL') }}</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach ($users as $usr)
                    <tr id="{{ $usr->id }}">
                      <td>{{ $loop->iteration }}</td>
                      <td><a href="#">{{ $usr->name }}</a> <br>{{ __('messages.'.strtoupper($usr->type)) }}</td>
                      <td>{{ $usr->email }}</td>
                      <td>
                        @foreach ($usr->roles()->get() as $role)
                          @if ($role->id==1)
                            <span style="color:green;">{!! $role->display_name.'<br>' !!}</span><br>
                          @elseif($role->id<40)
                            @if ($role->id==3)
                              <small>{!! $role->display_name.'<br>' !!}</small>
                                @foreach ($usr->permissions()->get() as $permission)
                                -- <small>{!! $permission->display_name.'<br>' !!}</small>
                                @endforeach
                                <br>
                            @else
                              @if ($role->id==2)
                              <small>{!! $role->display_name.'<br>' !!}</small><br>
                              @else
                              <small>{!! $role->display_name.'<br>' !!}</small>
                              @endif
                            @endif
                          @endif
                        @endforeach
                      </td>
                      {{-- @ability(['admin','super_admin'],['']) --}}
                      <td><button type="button" id="{{ $usr->id }}" class="is_active btn btn-outline-{{ $usr->is_active==1?'success':'warning' }} btn-border-radius"><span id="span-{{ $usr->id }}">{{ $usr->is_active==1? __('messages.ACTIVATED') : __('messages.UNACTIVATED') }}</span></button></td>
                      {{-- @endability --}}
                      <td>{{ $usr->created_at }}</td>
                      <td>
                       
                        <a href="{{ route('users.edit',$usr->id) }}" style="color: white"><button type="button" class="btn btn-info btn-circle waves-effect waves-circle waves-float">
                            <i class="material-icons">mode_edit</i></a>
                        </button>
                        {{-- @ability(['publisher','admin','super_admin'],[''])                         --}}
                        <button type="button" class="delete btn btn-danger btn-circle waves-effect waves-circle waves-float" id="{{ $usr->id.','.$usr->name.','. __('messages.Are you sure you want to delete the row named:') }}">
                            <i class="material-icons">delete_forever</i>
                        </button>
                        {{-- @endability --}}
                      </td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
              {{ $users->links() }}
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">{{ __('messages.Confirm Deletion') }}</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body" id='modal_content'>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-info waves-effect" id="delete_btn">{{ __('messages.YES') }}</button>
        {{-- <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal">{{ __('messages.NO') }}</button> --}}
      </div>
    </div>
  </div>
</div>
@endsection
@push('plugin_js')
{{-- <script src="{{ asset('BackEnd/js/table.min.js') }}"></script> --}}
@endpush
@push('custom_js')
{{-- <script src="{{ asset('BackEnd/js/pages/tables/jquery-datatable.js') }}"></script> --}}
@endpush

@push('is_active_ajax')
  <script>
    $(document).ready(function () {
      $('.is_active').on('click',function(){
        var $usr_id = $(this).attr('id');
        // alert($usr_id);
        $.getJSON("/alawqaf_panel/users/status/" + $usr_id, function(data) {
          $.each(data, function(index, item) {
            if(item==1)
            $('#span-'+$usr_id).html('<span style="color:#29b474">مفعّل</span>');
            if(item==-1)
            $('#span-'+$usr_id).html('<span style="color:#eb5757">غير مفعّل</span>');
          });
        });
      });

      var del;
      $('.delete').on('click',function(){
        del = $(this).attr('id').split(',');
        // alert(del[0]);
        // alert(del[1]);
        // alert(del[2]);
        $('#deleteModal').modal('show');
        $('#modal_content').html(del[2]+"<br>\
        <p class='alert alert-warning modal__text'>"+del[1]+" </p>");
        $('.modal__btns').show();
      });
      $('#delete_btn').on('click', function() {
        $.getJSON("/alawqaf_panel/users/delete/" + del[0], function(data) {
          $('#modal_content').html("<p class='alert alert-warning'> تم الحذف بنجاح <p>");
            $('.modal__btns').hide();
            $('#deleteModal').modal('toggle');
            $('#'+del[0]+'').fadeOut(1500);
        });
      });
    });
  </script>
@endpush
