@extends('BackEnd.Layouts.main')
@section('title')
  {{ __('messages.Edit User') }}
@endsection

@section('content')
  <section class="content">
    <div class="container-fluid">
      @include('BackEnd.Layouts.breadcrumb')
      @if (session('success'))
        <div class="alert alert-success text-center">
          {{ session('success') }}
        </div>
      @endif
      @if (session('error'))
        <div class="alert alert-danger text-center">
          {{ session('error') }}
        </div>
      @endif

      <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
          <div class="card">
            @include('BackEnd.Layouts.tableheader')
            <div class="body">
              <form id="form_validation" method="POST" action="{{ route('users.update', $user->id) }}"
                enctype="multipart/form-data">
                @csrf
                @if ($user->id == auth()->user()->id)
                {{-- @if (false) --}}
                <div class="row">
                  <div class="col-md-4">
                    <div class="form-group form-float">
                      <div class="form-line">
                        <input type="text" class="form-control" name="name" value="{{ $user->name }}" required>
                        <label class="form-label">{{ __('messages.NAME') }}</label>
                        @if ($errors->has('name'))
                          <label class="alert alert-danger">{{ $errors->first('name') }}</label>
                        @endif
                      </div>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group form-float">
                      <div class="form-line">
                        <input type="email" class="form-control" name="email" value="{{ $user->email }}" required>
                        <label class="form-label">{{ __('messages.EMAIL') }}</label>
                        @if ($errors->has('email'))
                          <label class="alert alert-danger">{{ $errors->first('email') }}</label>
                        @endif
                      </div>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group form-float">
                      <div class="form-line">
                        <input type="password" class="form-control" name="password" value=""
                          placeholder="اذا لم تغير كلمة المرور سيتم اعتماد السابقة">
                        <label class="form-label">{{ __('messages.PASSWORD') }}</label>
                        @if ($errors->has('password'))
                          <label class="alert alert-danger">{{ $errors->first('password') }}</label>
                        @endif
                        <input type="hidden" class="form-control" name="old_password" value="{{ $user->password }}">
                      </div>
                    </div>
                  </div>
                  {{-- <div class="col-md-2" style="margin-top: 10px">
                    <div class="form-group default-select select2Style">
                      <select class="form-control select2" name="user_roles[]" data-placeholder="Select">
                        @foreach ($roles as $role)
                          @if ($role->id > 40 && $role->id < 50)
                            <option value="{{ $role->id }}"
                              @foreach ($user->roles as $usr)
                            @if ($role->id == $usr->id)
                            selected
                            @endif @endforeach>
                              {{ $role->display_name }}</option>
                          @endif
                        @endforeach
                      </select>
                    </div>
                  </div> --}}
                  <div class="col-md-12">
                    <div class="form-group default-select select2Style">
                      @if ($errors->has('user_role'))
                        <label class="alert alert-danger">{{ $errors->first('user_role') }}</label>
                      @endif
                      
                     
                    </div>
                  </div>
                  <div class="form-group">
                    <div class="form-check m-l-10">
                      <label class="form-check-label">
                        <input class="form-check-input" type="checkbox" id="checkbox" name="is_active" checked>
                        {{ __('messages.ACTIVATED') }}
                        <span class="form-check-sign">
                          <span class="check"></span>
                        </span>
                      </label>
                    </div>
                  </div>
                  <button class="btn btn-primary waves-effect" type="submit">{{ __('messages.UPDATE') }}</button>
                </div>
                @elseif($user->id>1)
                {{-- @elseif(true) --}}
                <div class="row">
                  <div class="col-md-3">
                    <div class="form-group form-float">
                      <div class="form-line">
                        <input type="text" class="form-control" name="name" value="{{ $user->name }}" required>
                        <label class="form-label">{{ __('messages.NAME') }}</label>
                        @if ($errors->has('name'))
                          <label class="alert alert-danger">{{ $errors->first('name') }}</label>
                        @endif
                      </div>
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group form-float">
                      <div class="form-line">
                        <input type="email" class="form-control" name="email" value="{{ $user->email }}" required>
                        <label class="form-label">{{ __('messages.EMAIL') }}</label>
                        @if ($errors->has('email'))
                          <label class="alert alert-danger">{{ $errors->first('email') }}</label>
                        @endif
                      </div>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group form-float">
                      <div class="form-line">
                        <input type="password" class="form-control" name="password" value=""
                          placeholder="اذا لم تغير كلمة المرور سيتم اعتماد السابقة">
                        <label class="form-label">{{ __('messages.PASSWORD') }}</label>
                        @if ($errors->has('password'))
                          <label class="alert alert-danger">{{ $errors->first('password') }}</label>
                        @endif
                        <input type="hidden" class="form-control" name="old_password" value="{{ $user->password }}">
                      </div>
                    </div>
                  </div>
                  <div class="col-md-2" style="margin-top: -10px">
                    
                    <div class="form-group default-select select2Style">
                      <label class="form-label">الرتبة</label>
                      <select class="form-control select2" name="user_roles[]" data-placeholder="Select">
                        @foreach ($roles as $role)
                          @if ($role->id > 40 && $role->id < 50)
                            <option value="{{ $role->id }}"
                              @foreach ($user->roles as $usr)
                            @if ($role->id == $usr->id)
                            selected
                            @endif @endforeach>
                              {{ $role->display_name }}</option>
                          @endif
                        @endforeach
                      </select>
                      
                    </div>
                  </div>
                  <div class="col-md-12">
                    <div class="form-group default-select select2Style">
                      @if ($errors->has('user_role'))
                        <label class="alert alert-danger">{{ $errors->first('user_role') }}</label>
                      @endif
                      <table class="table table-bordered table-striped table-hover save-stage dataTable"
                        style="width:100%;">
                        <thead>
                          <tr>
                            <th>مدير النظام</th>
                            <th>
                              <div class="form-group" style="margin-bottom:0">
                                <div class="form-check m-l-10" style="margin-bottom:0">
                                  <label class="form-check-label">
                                    <input class="form-check-input admin_checkbox" value='1' type="checkbox"
                                      id="checkbox" name="user_roles[]">
                                    هذا الخيار يجعل للمحرر جميع صلاحيات الإدارة
                                    <span class="form-check-sign">
                                      <span class="check"></span>
                                    </span>
                                  </label>
                                </div>
                              </div>
                            </th>
                          </tr>
                        </thead>
                        <tbody>
                          <tr>
                            <td>
                              الأخبار
                            </td>
                            <td>
                              @foreach ($roles as $role)
                              @if($role->id==3)
                              <div class="form-group" style="margin-bottom:0">
                                <div class="form-check m-l-10" style="margin-bottom:0">
                                  <label class="form-check-label">
                                    <input class="form-check-input subadmin_checked news_checked" value='{{ $role->id }}' type="checkbox" id="checkbox" name="user_roles[]"
                                    @foreach ($user->roles()->get() as $user_role)
                                    @if ($role->id==$user_role->id)
                                    checked
                                    @endif
                                    @endforeach
                                    >
                                    {{ $role->display_name }}
                                    <span class="form-check-sign">
                                      <span class="check"></span>
                                    </span>
                                  </label>
                                </div>
                              </div>
                              <table>
                                @foreach ($role->permissions as $permission)
                                <tr>
                                  <td style="padding: 5px 10px 0 0;">
                                    <div class="form-group" style="margin-bottom:0">
                                      <div class="form-check m-l-10" style="margin-bottom:0">
                                        <label class="form-check-label">
                                          <input class="form-check-input subadmin_checked subnews_checked" value='{{ $permission->id }}' type="checkbox" id="checkbox" name="user_permission[]"
                                          @foreach ($user->permissions as $usr)
                                                  @if ($permission->id==$usr->id)
                                                  checked
                                                  @endif
                                                @endforeach
                                          >
                                          {{ $permission->display_name }}
                                          <span class="form-check-sign">
                                            <span class="check"></span>
                                          </span>
                                        </label>
                                      </div>
                                    </div>
                                  </td>
                                </tr>
                                @endforeach
                              </table>
                              @endif
                              @endforeach
                            </td>
                          </tr>
                          <tr>
                            <td>المقالات</td>
                            <td>
                              @foreach ($roles as $role)
                              @if($role->id==2)
                              <div class="form-group" style="margin-bottom:0">
                                <div class="form-check m-l-10" style="margin-bottom:0">
                                  <label class="form-check-label">
                                    <input class="form-check-input subadmin_checked" value='{{ $role->id }}' type="checkbox" id="checkbox" name="user_roles[]"
                                    @foreach ($user->roles()->get() as $user_role)
                                          @if ($role->id==$user_role->id)
                                          checked
                                          @endif
                                        @endforeach
                                    >
                                    {{ $role->display_name }}
                                    <span class="form-check-sign">
                                      <span class="check"></span>
                                    </span>
                                  </label>
                                </div>
                              </div>
                              @endif
                              @endforeach
                            </td>
                          </tr>
                          <tr>
                            <td>أخرى</td>
                            <td>
                              @foreach($roles as $role)
                             
                              @if ($role->id > 3 && $role->id < 40)
                              <div class="form-group" style="margin-bottom:0">
                                <div class="form-check m-l-10" style="margin-bottom:0">
                                  <label class="form-check-label" style="color:{{ $role->id==18?'red':'' }}">
                                    <input class="form-check-input subadmin_checked" value='{{ $role->id }}' type="checkbox" id="checkbox" name="user_roles[]"
                                    @foreach ($user->roles as $usr)
                                      @if ($role->id==$usr->id)
                                      checked
                                      @endif
                                    @endforeach
                                    >
                                    {{ $role->display_name }}
                                    <span class="form-check-sign">
                                      <span class="check"></span>
                                    </span>
                                  </label>
                                </div>
                              </div>
                              @endif
                              @endforeach
                            </td>
                          </tr>
                        </tbody>
                      </table>
                    </div>
                  </div>
                  <div class="form-group">
                    <div class="form-check m-l-10">
                      <label class="form-check-label">
                        <input class="form-check-input" type="checkbox" id="checkbox" name="is_active" checked>
                        {{ __('messages.ACTIVATED') }}
                        <span class="form-check-sign">
                          <span class="check"></span>
                        </span>
                      </label>
                    </div>
                  </div>
                  <button class="btn btn-primary waves-effect" type="submit">{{ __('messages.UPDATE') }}</button>
                </div>
                @endif
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
@endsection
@push('plugin_js')
  <script src="{{ asset('BackEnd/js/form.min.js') }}"></script>
  <script src="{{ asset('BackEnd/js/bundles/multiselect/js/jquery.multi-select.js') }}"></script>
  <script src="{{ asset('BackEnd/js/bundles/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.js') }}"></script>
@endpush
@push('custom_js')
  <script src="{{ asset('BackEnd/js/pages/forms/basic-form-elements.js') }}"></script>
  <script src="{{ asset('BackEnd/js/tinymce/js/tinymce/tinymce.min.js') }}"></script>
  <script src="{{ asset('BackEnd/js/tinymce/js/tinymce/jquery.tinymce.min.js') }}"></script>
  <script src="{{ asset('BackEnd/js/pages/forms/advanced-form-elements.js') }}"></script>
  <script>
    $(document).ready(function() {
      $('.admin_checkbox').on('change', function() {
        if (!$(this).is(':checked')) {
          $('.subadmin_checked').attr('checked', false);

        } else {
          $('.subadmin_checked').attr('checked', true);
          // $(this).val(null);
        }

      });
      $('.news_checked').on('change', function() {
        if (!$(this).is(':checked')) {
          $('.subnews_checked').attr('checked', false);
        } else {
          $('.subnews_checked').attr('checked', true);
        }
      });
    });
  </script>
@endpush
