@extends('BackEnd.Layouts.main')
@section('title')
الأعدادات العامة
@endsection

@section('content')

<section class="content">
  <div class="container-fluid">
    @include('BackEnd.Layouts.breadcrumb')
      @if(session('success'))
      <div class="alert alert-success text-center">
        {{session("success")}}
      </div>
      @endif
      @if(session('error'))
      <div class="alert alert-danger text-center">
        {{ session('error') }}
      </div>
      @endif

    <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
          <div class="body">
            <form id="form_validation" method="POST" action="{{ route('update_setting', $setting->id) }}" enctype="multipart/form-data">
              @csrf
              <div class="row">

                <div class="col-md-4">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="facebook"  value="{{$setting->facebook}}">
                      <label class="form-label">رابط فيسبوك</label>
                      @if ($errors->has('facebook'))
                      <label class="alert alert-danger">{{ $errors->first('facebook') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                
                <div class="col-md-4">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="instagram"  value="{{$setting->instagram}}">
                      <label class="form-label">رابط انستجرام</label>
                      @if ($errors->has('instagram'))
                      <label class="alert alert-danger">{{ $errors->first('instagram') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                        
                                        
                <div class="col-md-4">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="x"  value="{{$setting->x}}">
                      <label class="form-label">رابط X</label>
                      @if ($errors->has('x'))
                      <label class="alert alert-danger">{{ $errors->first('x') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                
               <div class="col-md-4">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="tiktok"  value="{{$setting->tiktok}}">
                      <label class="form-label">رابط Tiktok</label>
                      @if ($errors->has('tiktok'))
                      <label class="alert alert-danger">{{ $errors->first('tiktok') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                                
               <div class="col-md-4">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="youtube"  value="{{$setting->youtube}}">
                      <label class="form-label">رابط Youtube</label>
                      @if ($errors->has('youtube'))
                      <label class="alert alert-danger">{{ $errors->first('youtube') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                       
                <button class="btn btn-primary waves-effect" type="submit">{{ __('messages.Add') }}</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>


  </div>
</section>
@endsection
@push('plugin_js')
<script src="{{ asset('BackEnd/js/form.min.js') }}"></script>
@endpush
@push('custom_js')
<script src="{{ asset('BackEnd/js/pages/forms/basic-form-elements.js') }}"></script>
@endpush
