@extends('BackEnd.Layouts.main')
@section('title')
{{ __('messages.Edit Photo') }}
@endsection

@section('content')


<section class="content">
  <div class="container-fluid">
    @include('BackEnd.Layouts.breadcrumb')
    @if(session('success'))
    <div class="alert alert-success text-center">
      {{session("success")}}
    </div>
    @endif
    @if(session('error'))
    <div class="alert alert-danger text-center">
      {{ session('error') }}
    </div>
    @endif

    <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
          @include('BackEnd.Layouts.tableheader')
          <div class="body">
            <form id="form_validation" method="POST" action="{{ route('photos.update',$photo->id) }}" enctype="multipart/form-data">
              @csrf
              <div class="row">
                {{-- <div class="col-md-12">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="name" value="{{ $photo->name }}" required>
                      <label class="form-label">{{ __('messages.TITLE') }}</label>
                      @if ($errors->has('name'))
                      <label class="alert alert-danger">{{ $errors->first('name') }}</label>
                      @endif
                    </div>
                  </div>
                </div> --}}
               
               
                <div class="col-6">
                  <div class="file-field input-field">
                    <div class="btn">
                      <span>{{ __('messages.Choose a picture') }}</span>
                      <input type="file" name="image">
                    </div>
                    <div class="file-path-wrapper">
                      <input class="file-path validate" type="text" name="image" placeholder="{{ __('messages.Click to add a photo') }}">
                      <input class="file-path validate" type="hidden" name="old_image" value="{{ $photo->getRawOriginal('image') }}">
                       @if ($errors->has('image'))
                      <label class="alert alert-danger">{{ $errors->first('image') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-2">
                  <img src="{{$photo->image }}" alt="">
                </div>
                <div class="col-md-2">
                  <p>
                    <b>النوع</b>
                  </p>
                  <div class="form-group default-select select2Style">
                    <select class="form-control select2" id="type" name="type" data-placeholder="الفئة الرئيسية"
                      required>
                      <option value="">اختر من القائمة</option>
                      <option value="photos" {{ $category->type=='photos'?'selected':'' }}>البوم صور</option>
                      <option value="interactive_stories" {{ $category->type=='interactive_stories'?'selected':'' }}>قصص تفاعلية</option>
                      <option value="comic" {{ $category->type=='comic'?'selected':'' }}>كوميكس</option>
                      <option value="infographic" {{ $category->type=='infographic'?'selected':'' }}>انفوجراف</option>
                      {{-- <option value="podcast" {{ $category->type=='podcast'?'selected':'' }}>بودكاست</option> --}}
                      {{-- <option value="videos" {{ $category->type=='videos'?'selected':'' }}>فيديو</option> --}}
                    </select>
                  </div>
                </div>
                <div class="col-md-2">
                  <p>
                    <b>الالبوم</b>
                  </p>
                  <div class="form-group default-select select2Style">
                    <select class="form-control select2" id="category_id" name="category_id" data-placeholder="Select">
                      <option value="0">رئيسي</option>
                      @forelse ($categories as $cat)
                      @if ($category->type==$cat->type)
                      <option value="{{ $cat->slug }}" {{ $category->slug==$cat->slug?'selected':'' }}>{{ $cat->name_ar }}</option>
                      @endif
                        
                      @empty
                        
                      @endforelse
                    </select>
                  </div>
                </div>

                 {{-- <div class="col-md-2">
                  <div class="form-group default-select select2Style">
                    <select class="form-control select2" name="category_id" data-placeholder="حدد البرنامج" required>
                      <option></option>
                      @foreach ($categories as $cat)
                      <option value="{{ $cat->id }}" {{ $photo->category_id==$cat->id?'selected':'' }}>{{ $cat->name_ar }}</option>
                      @endforeach
                    </select>
                  </div>
                </div> --}}
               
                <div class="form-group">
                  <div class="form-check m-l-10">
                    <label class="form-check-label">
                      <input class="form-check-input" type="checkbox" id="checkbox" name="is_active" {{ $photo->is_active==1?'checked':'' }}>
                      {{ __('messages.PUBLISHED') }}
                      <span class="form-check-sign">
                        <span class="check"></span>
                      </span>
                    </label>
                  </div>
                </div>
                <button class="btn btn-primary waves-effect" type="submit">{{ __('messages.UPDATE') }}</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>


  </div>
</section>



@endsection
@push('plugin_js')
  <script src="{{ asset('BackEnd/js/form.min.js') }}"></script>
  <script src="{{ asset('BackEnd/js/bundles/multiselect/js/jquery.multi-select.js') }}"></script>
  <script src="{{ asset('BackEnd/js/bundles/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.js') }}"></script>
@endpush
@push('custom_js')
  <script src="{{ asset('BackEnd/js/pages/forms/basic-form-elements.js') }}"></script>
  <script src="{{ asset('BackEnd/js/pages/forms/advanced-form-elements.js') }}"></script>
  <script>
    $(document).ready(function() {
      $('#type').on('change', function() {
        $('#category_id').empty();
        $.getJSON("/eco_panel/get_album/" + $(this).val(), function(data) {
          $('#category_id').show();
          $('#category_id').html('<option value="0">رئيسي</option>');
          $.each(data, function(index, item) {
            $('#category_id').append(
              $('<option></option>').val(item["id"]).html(item["name"])
            );
          });
        });
      });
    });
  </script>
@endpush
