@extends('BackEnd.Layouts.main')
@section('title')
عرض ملفات PDF
@endsection
@section('content')
<section class="content">
  <div class="container-fluid">
    @include('BackEnd.Layouts.breadcrumb')
    @if(session('success'))
    <div class="alert alert-success text-center">
      {{session("success")}}
    </div>
    @endif
    @if(session('error'))
    <div class="alert alert-danger text-center">
      {{ session('error') }}
    </div>
    @endif

    <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
          @include('BackEnd.Layouts.tableheader')
          <div class="body">
            <div class="table-responsive">
              <table id="table" class="table table-bordered table-striped table-hover save-stage dataTable" style="width:100%;">
                <thead>
                  <tr>
                    <th>م</th>
                    <th>اسم المف</th>
                    <th>تحميل الملف</th>
                    <th>نوع الملف</th>
                    <th>التحكم</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach ($pdfs as $pdf)
                  <tr id="{{ $pdf->id }}">
                    <td>{{ $loop->iteration }}</td>
                    <td><a href="#">{{ $pdf->name }}</a></td>
		   <td><a class="btn btn-info btn-sm" href="{{asset('upload/pdf/'.$pdf->pdf)}}" download target="_blank">تحميل الملف</td>
		   <td>
		   	@if($pdf->type == 0)
		   		جديد
		   	@else
		   		مؤرشف
		   	@endif
		   </td>
                   <td>
                      @ability(['publisher','admin','super_admin'],[''])
                      
                      @if(true)
                      <button type="button" class="delete btn btn-danger btn-circle waves-effect waves-circle waves-float" id="{{ $pdf->id.','.$pdf->name.','. __('messages.Are you sure you want to delete the row named:') }}">
                        <i class="material-icons">delete_forever</i>
                      </button>
                      @endif
                      @endability
                    </td>
                  </tr>
                  @endforeach
                </tbody>
              </table>
              
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">{{ __('messages.Confirm Deletion') }}</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body" id='modal_content'>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-info waves-effect" id="delete_btn">{{ __('messages.YES') }}</button>
        {{-- <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal">{{ __('messages.NO') }}</button> --}}
      </div>
    </div>
  </div>
</div>
@endsection
@push('plugin_js')
{{-- <script src="{{ asset('BackEnd/js/table.min.js') }}"></script> --}}
@endpush
@push('custom_js')
{{-- <script src="{{ asset('BackEnd/js/pages/tables/jquery-datatable.js') }}"></script> --}}
<script>
  // $('#table').DataTable({
  //   paging: true
  //   , searching: true
  //   , "language": {
  //     "url": "//cdn.datatables.net/plug-ins/1.11.3/i18n/ar.json"
  //   }
  // });

</script>

@endpush

@push('is_active_ajax')


<script>
  $(document).ready(function() {
    $('.is_active').on('click', function() {
      var $news_id = $(this).attr('id');
      // alert($news_id);
      $.getJSON("/eco_panel/breakingnews/status/" + $news_id, function(data) {
        $.each(data, function(index, item) {
          if (item == 1)
            $('#span-' + $news_id).html('<span style="color:#29b474">منشور</span>');
          if (item == -1)
            $('#span-' + $news_id).html('<span style="color:#eb5757">غير منشور</span>');
        });
      });
    });

    var del;
    $('.delete').on('click', function() {
      del = $(this).attr('id').split(',');
      // alert(del[0]);
      // alert(del[1]);
      // alert(del[2]);
      $('#deleteModal').modal('show');
      $('#modal_content').html(del[2] + "<br>\
        <p class='alert alert-warning modal__text'>" + del[1] + " </p>");
      $('.modal__btns').show();
    });
    $('#delete_btn').on('click', function() {
      $.getJSON("/eco_panel/pdf/delete/" + del[0], function(data) {
        $('#modal_content').html("<p class='alert alert-warning'> تم الحذف بنجاح <p>");
        $('.modal__btns').hide();
        $('#deleteModal').modal('toggle');
        $('#' + del[0] + '').fadeOut(1500);
      });
    });
  });

</script>
@endpush
