@extends('BackEnd.Layouts.main')
@section('title')
اضافة ملف PDF
@endsection

@section('content')

<section class="content">
  <div class="container-fluid">
    @include('BackEnd.Layouts.breadcrumb')
      @if(session('success'))
      <div class="alert alert-success text-center">
        {{session("success")}}
      </div>
      @endif
      @if(session('error'))
      <div class="alert alert-danger text-center">
        {{ session('error') }}
      </div>
      @endif

    <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
          @include('BackEnd.Layouts.tableheader')
          <div class="body">
            <form id="form_validation" method="POST" action="{{ route('pdf.store') }}" enctype="multipart/form-data">
              @csrf
              <div class="row">
              
                <div class="col-md-12">
                  <div class="file-field input-field">
                    <div class="btn">
                      <span>اختيار ملف PDF </span>
                      <input type="file"  name="pdf" accept=".pdf" required>
                    </div>
                    <div class="file-path-wrapper">
                      <input class="file-path validate" type="text" name="pdf" placeholder="انقر لأختيار ملف PDF" required>
                      @if ($errors->has('pdf'))
                      <label class="alert alert-danger">{{ $errors->first('pdf') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="name"  required>
                      <label class="form-label">اسم الملف</label>
                      @if ($errors->has('name'))
                      <label class="alert alert-danger">{{ $errors->first('name') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                               
                <button class="btn btn-primary waves-effect" type="submit">{{ __('messages.Add') }}</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>


  </div>
</section>
@endsection
@push('plugin_js')
<script src="{{ asset('BackEnd/js/form.min.js') }}"></script>
@endpush
@push('custom_js')
<script src="{{ asset('BackEnd/js/pages/forms/basic-form-elements.js') }}"></script>
@endpush
