@extends('BackEnd.Layouts.main')
@section('title')
{{ __('messages.Edit Newspaper') }}
@endsection

@section('content')


<section class="content">
  <div class="container-fluid">
    @include('BackEnd.Layouts.breadcrumb')
    @if(session('success'))
    <div class="alert alert-success text-center">
      {{session("success")}}
    </div>
    @endif
    @if(session('error'))
    <div class="alert alert-danger text-center">
      {{ session('error') }}
    </div>
    @endif

    <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
          @include('BackEnd.Layouts.tableheader')
          <div class="body">
            <form id="form_validation" method="POST" action="{{ route('newspapers.update',$newspaper->id) }}" enctype="multipart/form-data">
              @csrf
              <div class="row">
                <div class="col-md-12">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="number" class="newspaper_number form-control" name="newspaper_number" value="{{ $newspaper->newspaper_number }}" required>
                      <label class="form-label">رقم العدد</label>
                      @if ($errors->has('newspaper_number'))
                      <label class="alert alert-danger">{{ $errors->first('newspaper_number') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="url" value="{{ $newspaper->url }}" required>
                      <label class="form-label">رابط العدد url</label>
                      @if ($errors->has('url'))
                      <label class="alert alert-danger">{{ $errors->first('url') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                
                <div class="col-md-12">
                  <div class="file-field input-field">
                    <div class="btn">
                      <span>{{ __('messages.Choose a picture') }}</span>
                      <input type="file" name="image">
                    </div>
                    <div class="file-path-wrapper">
                      <input class="file-path validate" type="text" name="image" placeholder="{{ __('messages.Click to add a photo') }} الغلاف">
                      <input class="file-path validate" type="hidden" name="old_image" value="{{ $newspaper->getRawOriginal('image') }}">
                      @if ($errors->has('image'))
                      <label class="alert alert-danger">{{ $errors->first('image') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-sm-12">
                  <div class="form-group">
                    <div class="form-line">
                      <label for="email_address">تاريخ صدور العدد</label>
                      <input id="myDatePicker" name="publish_up" class="flatPicker" value="{{ $newspaper->publish_up }}" placeholder="اختر تاريخ صدور العدد" required>
                    </div>
                  </div>
                </div>
              </div>
              <div class="form-group">
                <div class="form-check m-l-10">
                  <label class="form-check-label">
                    <input class="form-check-input" type="checkbox" id="checkbox" name="is_active" checked>
                    {{ __('messages.PUBLISHED') }}
                    <span class="form-check-sign">
                      <span class="check"></span>
                    </span>
                  </label>
                </div>
              </div>
              <button class="btn btn-primary waves-effect" type="submit">{{ __('messages.UPDATE') }}</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>


  </div>
</section>



@endsection
@push('plugin_js')
<script src="{{ asset('BackEnd/js/form.min.js') }}"></script>
@endpush
@push('custom_js')
<script src="{{ asset('BackEnd/js/pages/forms/basic-form-elements.js') }}"></script>
@endpush
@push('newspaper_ajax')
<script>
  $(document).ready(function(e) {
    $('.newspaper').on('change', function(e) {
      e.preventDefault();

      var np_number = $('.newspaper_number').val();
      // alert(np_number);
      var np_id = $(this).attr('id').split('-');
      var id = np_id[1];
      // alert(id);
      var file_data = $("#newspaper-" + id).prop("files")[0];
      var formData = new FormData();
      formData.append("file", file_data);

      $.ajax({
        type: 'POST'
        , url: "/news_panel/uploadFile/" + id
        , headers: {
          'X-Csrf-Token': $('meta[name="csrf-token"]').attr('content')
        }
        , data: formData
        , cache: false
        , contentType: false
        , processData: false,

        beforeSend: function() {
          $("#responce-" + id).show();
          $("#loading-" + id).show();
        }
        , success: function(data) {
          // this.reset();
          if (data) {
            $("#loading-" + id).hide();
            $('#success-' + id).html("<span>تم الرفع</span>");
            $('#np-' + id).val(data);
            if (data == '1.pdf') {
              $('#image').val('1.png');
            }
          }
        }
        , error: function(data) {
          console.log(data);
        }
      });
    });
  });
</script>
@endpush
