@extends('BackEnd.Layouts.main')
@section('title')
رسالة جماعية
@endsection

@section('content')

<section class="content">
  <div class="container-fluid">
    @include('BackEnd.Layouts.breadcrumb')
    @if(session('success'))
    <div class="alert alert-success text-center">
      {{session("success")}}
    </div>
    @endif
    @if(session('error'))
    <div class="alert alert-danger text-center">
      {{ session('error') }}
    </div>
    @endif

    <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
          @include('BackEnd.Layouts.tableheader')
          <div class="body">
            <form id="form_validation" method="POST" action="{{ route('newsletters.sendmail') }}" enctype="multipart/form-data">
              @csrf
              <div class="row">
                <div class="col-md-4" style="display: none">
                  <p>
                    <b>قائمة الإيميلات</b>
                  </p>
                  <div class="form-group default-select select2Style">
                    <select class="form-control select2" name="email[]" data-placeholder="Select" multiple>
                      <option>اختر تصنيف</option>
                      @foreach ($emails as $email)
                            <option value="{{ $email->email }}" selected>{{ $email->email }}</option>
                          @endforeach
                    </select>
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="subject" value="{{ old('subject') }}" required>
                      <label class="form-label">عنوان الرسالة</label>
                      @if ($errors->has('subject'))
                      <label class="alert alert-danger">{{ $errors->first('subject') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <textarea class="tinymce" name="message" placeholder="نص الرسالة">{{ old('message') }}</textarea>
                      <label class="form-label">نص الرسالة</label>
                      @if ($errors->has('message'))
                      <label class="alert alert-danger">{{ $errors->first('message') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <button class="btn btn-primary waves-effect" type="submit">{{ __('messages.SEND') }}</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>



@endsection
@push('plugin_js')
<script src="{{ asset('BackEnd/js/form.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/bundles/multiselect/js/jquery.multi-select.js') }}"></script>
<script src="{{ asset('BackEnd/js/bundles/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.js') }}"></script>
@endpush
@push('custom_js')
<script src="{{ asset('BackEnd/js/newsletters/forms/basic-form-elements.js') }}"></script>
<script src="{{ asset('BackEnd/js/tinymce/js/tinymce/tinymce.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/tinymce/js/tinymce/jquery.tinymce.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/newsletters/forms/advanced-form-elements.js') }}"></script>
@endpush

@push('tinymce')
<script>
  $(document).ready(function() {
    $('#add_image').on('click', function() {
      $('#gallery-content').append('<div class="col-md-12">\
      <div class="file-field input-field">\
        <div class="btn">\
          <span>صورة اضافية</span>\
          <input type="file" name="gallery[]">\
        </div>\
        <div class="file-path-wrapper">\
          <input class="file-path validate" type="text" name="gallery[]" placeholder="انقر لاختيار صورة اضافية للخبر">\
          @if ($errors->has('
        gallery '))\
          <label class="alert alert-danger">{{ $errors->first('
        gallery ') }}</label>\
          @endif\
        </div>\
        <div class="form-check m-l-10">\
          <label class="form-check-label">\
            <input class="form-check-input" type="checkbox" id="checkbox" name="icon">\
            إضافة الشعار إلى الصورة\
            <span class="form-check-sign">\
              <span class="check"></span>\
            </span>\
          </label>\
        </div>\
      </div>\
    </div>');
    });
    $('#minus_button').on('click', function() {
      $('#gallery-content').children("div").last().remove();
    });

    tinymce.init({
        selector: 'textarea.tinymce',
        plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
        toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
        language: 'ar',
        height: 500,
        relative_urls: true,
        document_base_url: '//www.tiny.cloud/docs/demo',
        image_title: true,
        automatic_uploads: true,
        images_upload_url: '/upload',
        file_picker_types: 'image',
        file_picker_callback: function(cb, value, meta) {
          var input = document.createElement('input');
          input.setAttribute('type', 'file');
          input.setAttribute('accept', 'image/*');
          input.onchange = function() {
            var file = this.files[0];

            var reader = new FileReader();
            reader.readAsDataURL(file);
            reader.onload = function() {
              var id = 'blobid' + (new Date()).getTime();
              var blobCache = tinymce.activeEditor.editorUpload.blobCache;
              var base64 = reader.result.split(',')[1];
              var blobInfo = blobCache.create(id, file, base64);
              blobCache.add(blobInfo);
              cb(blobInfo.blobUri(), {
                title: file.name
              });
            };
          };
          input.click();
        }
      });
      
    // $('textarea.tinymce').tinymce({
    //   toolbar_mode: 'scrolling'
    //   , plugins: [
    //     'advlist autolink link image lists charmap print preview hr anchor pagebreak'
    //     , 'searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking'
    //     , 'table emoticons template paste help'
    //   ]
    //   , toolbar: 'undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | ' +
    //     'bullist numlist outdent indent | link image | print preview media fullscreen | ' +
    //     'forecolor backcolor emoticons | help'
    //   , menubar: 'file edit view insert format tools table help',
    //   // content_css: 'css/content.css'

    //   language: 'ar'
    //   , height: 500
    //     // , width: 720
    // , });
  });

</script>
@endpush
