@extends('BackEnd.Layouts.main')
@section('title')
تعديل مشترك
@endsection

@section('content')

<section class="content">
  <div class="container-fluid">
    @include('BackEnd.Layouts.breadcrumb')
    @if(session('success'))
    <div class="alert alert-success text-center">
      {{session("success")}}
    </div>
    @endif
    @if(session('error'))
    <div class="alert alert-danger text-center">
      {{ session('error') }}
    </div>
    @endif

    <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
          @include('BackEnd.Layouts.tableheader')
          <div class="body">
            <form id="form_validation" method="POST" action="{{ route('newsletters.update',$newsletter->id) }}" enctype="multipart/form-data">
              @csrf
              <div class="row">
                <div class="col-md-9">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="email" value="{{ $newsletter->email }}" required>
                      <label class="form-label">البريد الإلكتروني</label>
                      @if ($errors->has('email'))
                      <label class="alert alert-danger">{{ $errors->first('email') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-md-3">
                  <p>
                    <b>حالة النشر</b>
                  </p>
                  <div class="demo-switch">
                    <div class="switch">
                      <label>منشور
                        <input type="checkbox" name="is_active" {{ $newsletter->is_active==1?'checked':'' }}>
                        <span class="lever"></span>مسودة</label>
                    </div>
                  </div>
                </div>
                <button class="btn btn-primary waves-effect" type="submit">{{ __('messages.UPDATE') }}</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>



@endsection
@push('plugin_js')
<script src="{{ asset('BackEnd/js/form.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/bundles/multiselect/js/jquery.multi-select.js') }}"></script>
<script src="{{ asset('BackEnd/js/bundles/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.js') }}"></script>
@endpush
@push('custom_js')
<script src="{{ asset('BackEnd/js/newsletters/forms/basic-form-elements.js') }}"></script>
<script src="{{ asset('BackEnd/js/tinymce/js/tinymce/tinymce.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/tinymce/js/tinymce/jquery.tinymce.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/newsletters/forms/advanced-form-elements.js') }}"></script>
@endpush

@push('tinymce')
<script>
  $(document).ready(function() {
    $('#add_image').on('click', function() {
      $('#gallery-content').append('<div class="col-md-12">\
      <div class="file-field input-field">\
        <div class="btn">\
          <span>صورة اضافية</span>\
          <input type="file" name="gallery[]">\
        </div>\
        <div class="file-path-wrapper">\
          <input class="file-path validate" type="text" name="gallery[]" placeholder="انقر لاختيار صورة اضافية للخبر">\
          @if ($errors->has('
        gallery '))\
          <label class="alert alert-danger">{{ $errors->first('
        gallery ') }}</label>\
          @endif\
        </div>\
        <div class="form-check m-l-10">\
          <label class="form-check-label">\
            <input class="form-check-input" type="checkbox" id="checkbox" name="icon">\
            إضافة الشعار إلى الصورة\
            <span class="form-check-sign">\
              <span class="check"></span>\
            </span>\
          </label>\
        </div>\
      </div>\
    </div>');
    });
    $('#minus_button').on('click', function() {
      $('#gallery-content').children("div").last().remove();
    });

    $('textarea.tinymce').tinymce({
      toolbar_mode: 'scrolling'
      , plugins: [
        'advlist autolink link image lists charmap print preview hr anchor newsletterbreak'
        , 'searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking'
        , 'table emoticons template paste help'
      ]
      , toolbar: 'undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | ' +
        'bullist numlist outdent indent | link image | print preview media fullscreen | ' +
        'forecolor backcolor emoticons | help'
      , menubar: 'file edit view insert format tools table help',
      // content_css: 'css/content.css'

      language: 'ar'
      , height: 500
        // , width: 720
    , });
  });

</script>
@endpush
