@extends('BackEnd.Layouts.main')
@section('title')
{{ __('messages.View Deleted News') }}
@endsection
@section('content')
<section class="content">
  <div class="container-fluid">
    @include('BackEnd.Layouts.breadcrumb')
      @if(session('success'))
      <div class="alert alert-success text-center">
        {{session("success")}}
      </div>
      @endif
      @if(session('error'))
      <div class="alert alert-danger text-center">
        {{ session('error') }}
      </div>
      @endif

    <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
          @include('BackEnd.Layouts.tableheader')
          <div class="body">
            <div class="table-responsive">
              <table class="table table-bordered table-striped table-hover save-stage dataTable" style="width:100%;">
                <thead>
                  <tr>
                    <th>م</th>
                    <th>عنوان الخبر</th>
                    <th>في قسم</th>
                    {{-- @ability(['admin','super_admin'],['']) --}}
                    {{-- <th>الحالة</th> --}}
                    {{-- @endability --}}
                    <th>{{ __('messages.VIEWS') }}</th>
                    <th>التعليقات</th>
                    <th>{{ __('messages.PUBLISHED_DATE') }}</th>
                    <th>المحرر</th>
                    <th>تم الحذف بواسطة</th>
                    <th>{{ __('messages.CONTROL') }}</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach ($news as $new)
                    <tr id="{{ $new->id }}">
                      <td>{{ $new->id }}</td>
                      <td>{{ $new->title_ar }}</td>
                      <td>{{ $new->getCategory->name_ar }}</td>
                      {{-- @ability(['admin','super_admin'],['']) --}}
                      {{-- <td><button type="button" id="{{ $new->id }}" class="is_active btn btn-outline-{{ $new->is_active==1?'success':'warning' }} btn-border-radius"><span id="span-{{ $new->id }}">{{ $new->is_active==1? __('messages.PUBLISHED') : __('messages.UNPUBLISHED') }}</span></button></td> --}}
                      {{-- @endability --}}
                      <td>{{ $new->views }}</td>
                      <td>{{ $new->allow_comments }}</td>
                      <td><span style="font-size:xx-small">
                        {{ $new->created_at->toDateString() }}</span><br>
                        {{ $new->created_at->toTimeString() }}</td>
                    <td>{{ $new->getUser->name??'' }}</td>
                    <td>{{ $new->deletedBy->name??'' }}</td>
                      <td>
                 
                     

                        <button type="button" class="recover btn btn-warning btn-circle waves-effect waves-circle waves-float" id="{{ $new->id.','.$new->title.','. __('messages.Are you sure you want to recover the row named:') }}">

                            <i class="material-icons">save</i>
                        </button>
                        <button type="button" class="delete btn btn-danger btn-circle waves-effect waves-circle waves-float" id="{{ $new->id.','.$new->title.','. __('messages.Are you sure you want to delete the row named:') }}">
                          <i class="material-icons">delete_forever</i>
                        </button>


                      </td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
              {{ $news->links() }}
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">{{ __('messages.Confirm Deletion') }}</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body" id='modal_content'>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-info waves-effect" id="delete_btn">{{ __('messages.YES') }}</button>
        {{-- <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal">{{ __('messages.NO') }}</button> --}}
      </div>
    </div>
  </div>
</div>
@endsection
@push('plugin_js')
{{-- <script src="{{ asset('BackEnd/js/table.min.js') }}"></script> --}}
@endpush
@push('custom_js')
{{-- <script src="{{ asset('BackEnd/js/pages/tables/jquery-datatable.js') }}"></script> --}}
@endpush

@push('is_active_ajax')
  <script>
    $(document).ready(function () {
      $('.is_active').on('click',function(){
        var $new_id = $(this).attr('id');
        // alert($new_id);
        $.getJSON("/eco_panel/news/status/" + $new_id, function(data) {
          $.each(data, function(index, item) {
            if(item==1)
            $('#span-'+$new_id).html('<span style="color:#29b474">منشور</span>');
            if(item==-1)
            $('#span-'+$new_id).html('<span style="color:#eb5757">غير منشور</span>');
          });
        });
      });

      var del;
      $('.recover').on('click',function(){
        del = $(this).attr('id').split(',');
        // alert(del[0]);
        // alert(del[1]);
        // alert(del[2]);
        $('#deleteModal').modal('show');
        $('#modal_content').html(del[2]+"<br>\
        <p class='alert alert-warning modal__text'>"+del[1]+" </p>");
        $('.modal__btns').show();
      });
      $('#delete_btn').on('click', function() {
        $.getJSON("/eco_panel/news/recover/" + del[0], function(data) {
          // $('#modal_content').html("<p class='alert alert-warning'> تم الاستعادة بنجاح <p>");
            $('.modal__btns').hide();
            $('#deleteModal').modal('toggle');
            $('#'+del[0]+'').fadeOut(1500);
        });
      });

      var del;
      $('.delete').on('click',function(){
        del = $(this).attr('id').split(',');
        // alert(del[0]);
        // alert(del[1]);
        // alert(del[2]);
        $('#deleteModal').modal('show');
        $('#modal_content').html(del[2]+"<br>\
        <p class='alert alert-warning modal__text'>"+del[1]+" </p>");
        // $('.modal__btns').show();
      });
      $('#delete_btn').on('click', function() {
        $.getJSON("/eco_panel/news/destroy/" + del[0], function(data) {
          // $('#modal_content').html("<p class='alert alert-warning'> تم الحذف بنجاح <p>");
            $('.modal__btns').hide();
            $('#deleteModal').modal('toggle');
            $('#'+del[0]+'').fadeOut(1500);
        });
      });

    });
  </script>
@endpush
