@extends('BackEnd.Layouts.main')
@section('title')
{{ __('messages.Add News') }}
@endsection

@section('content')

<section class="content">
  <div class="container-fluid">
    @include('BackEnd.Layouts.breadcrumb')
      @if(session('success'))
      <div class="alert alert-success text-center">
        {{session("success")}}
      </div>
      @endif
      @if(session('error'))
      <div class="alert alert-danger text-center">
        {{ session('error') }}
      </div>
      @endif

    <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
          @include('BackEnd.Layouts.tableheader')
          <div class="body">
            <form id="form_validation" method="POST" action="{{ route('news.update',$news->id) }}" enctype="multipart/form-data">
              @csrf
              <div class="row">
                {{-- <div class="col-md-2">
                  <p>
                    <b>اللغة</b>
                  </p>
                  <div class="form-group default-select select2Style" style="margin-top: -20px;">
                    <select class="form-control select2" name="lang" data-placeholder="Select">
                        <option value="ar">عربي</option>
                        <option value="en" {{ $news->lang=='en'?'selected':'' }}>English</option>
                    </select>
                  </div>
                </div> --}}
                {{-- <div class="col-md-10">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="subtitle" value="{{ $news->subtitle }}">
                      <label class="form-label">عنوان استهلالي</label>
                      @if ($errors->has('subtitle'))
                      <label class="alert alert-danger">{{ $errors->first('subtitle') }}</label>
                      @endif
                    </div>
                  </div>
                </div> --}}
                <div class="col-md-12">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="title" value="{{ $news->title }}" required>
                      <label class="form-label">عنوان رئيسي</label>
                      @if ($errors->has('title'))
                      <label class="alert alert-danger">{{ $errors->first('title') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="source" value="{{ $news->source==''?'ايكونيوز - متابعة خاصة':$news->source }}" required>
                      <label class="form-label">مصدر الخبر</label>
                      @if ($errors->has('source'))
                      <label class="alert alert-danger">{{ $errors->first('source') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <textarea class="tinymce" name="details" placeholder="تفاصيل الخبر" >{{ $news->details }}</textarea>
                      <label class="form-label">تفاصيل الخبر</label>
                      @if ($errors->has('details'))
                      <label class="alert alert-danger">{{ $errors->first('details') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                

                {{-- <div class="col-9">
                  <div class="file-field input-field">
                    <div class="btn">
                      <span>صورة رئيسية للخبر</span>
                      <input type="file" name="image">
                    </div>
                    <div class="file-path-wrapper">
                      <input class="file-path validate" type="text" name="image" placeholder="انقر لاختيار صورة رئيسية للخبر">
                      <input class="file-path validate" type="hidden" name="old_image" value="{{ $news->getRawOriginal('image') }}">
                      @if ($errors->has('image'))
                      <label class="alert alert-danger">{{ $errors->first('image') }}</label>
                      @endif
                    </div>
                    <div class="form-check m-l-10">
                      <label class="form-check-label">
                        <input class="form-check-input" type="checkbox" id="checkbox" name="logo">
                        إضافة الشعار إلى الصورة
                        <span class="form-check-sign">
                          <span class="check"></span>
                        </span>
                      </label>
                    </div>
                  </div>
                </div> --}}
                {{-- <div class="col-2">
                  <img src="{{ $news->image }}" height="60px" alt="">
                </div> --}}

                {{-- <div class="col-1">
                  <button type="button" class="delete btn btn-info btn-circle waves-effect waves-circle waves-float" id="add_image">
                    <i class="material-icons">plus_one</i>
                  </button>
                  <button type="button" class="btn btn-info btn-circle waves-effect waves-circle waves-float" id="minus_button">
                    <i class="material-icons">indeterminate_check_box</i>
                  </button>
                </div> --}}
                {{-- {{count($gallery)}} --}}
                {{-- <div id="gallery-content">
                  @if (count($gallery)>0)
                  @foreach ($gallery as $imgs)
                  <div class="row">
                    <div class="col-10">
                      <div class="file-field input-field">
                        <div class="btn">
                          <span>{{ __('messages.Choose a picture') }}</span>
                          <input type="file" name="gallery[]">
                        </div>
                        <div class="file-path-wrapper">
                          <input class="file-path validate" type="text" name="gallery[]" placeholder="{{ __('messages.Click to add a photo') }}">
                          <input class="file-path validate" type="hidden" name="old_gallery[]" placeholder="{{ __('messages.Click to add a photo') }}" value="{{ $imgs }}">
                          @if ($errors->has('gallery'))
                          <label class="alert alert-danger">{{ $errors->first('gallery') }}</label>
                          @endif
                        </div>
                      </div>
                    </div>
                    <div class="col-1">
                      <img src="{{ asset('media/thumbs/news/'.$imgs) }}" alt="">
                    </div>
                  </div>
                  @endforeach
                  @else
                  <div class="row">
                    <div class="col-10">
                      <div class="file-field input-field">
                        <div class="btn">
                          <span>{{ __('messages.Choose a picture') }}</span>
                          <input type="file" name="gallery[]">
                        </div>
                        <div class="file-path-wrapper">
                          <input class="file-path validate" type="text" name="gallery[]" placeholder="{{ __('messages.Click to add a photo') }}">
                          <input class="file-path validate" type="hidden" name="old_gallery[]" placeholder="{{ __('messages.Click to add a photo') }}" value="{{ $news->gallery }}">
                          @if ($errors->has('gallery'))
                          <label class="alert alert-danger">{{ $errors->first('gallery') }}</label>
                          @endif
                        </div>
                      </div>
                    </div>
                    <div class="col-1">
                      <img src="{{ $gallery }}" alt="">
                    </div>
                  </div>
                  @endif
                </div> --}}
                
                {{-- <div class="col-md-3">
                  <p>
                    <b>القسم الرئيسي</b>
                  </p>
                  <div class="form-group default-select select2Style">
                    <select class="form-control select2" id="category_id" name="category_id" data-placeholder="Select">
                      @foreach ($categories as $cat)
                        <option value="{{ $cat->id }}" {{ $news->category_id==$cat->id?'selected':'' }}>{{ $cat->name }}</option>
                      @endforeach
                    </select>
                  </div>
                </div> --}}
                {{-- <div class="col-md-4">
                  <p>
                    <b>القسم الفرعي</b>
                  </p>
                  <div class="form-group default-select select2Style">
                    <select class="form-control select2" id="subcategory_id" name="subcategory_id" data-placeholder="Select">
                      <option value="0"></option>
                      @foreach ($subcategories as $cat)
                        <option value="{{ $cat->id }}" {{ $news->subcategory_id==$cat->id?'selected':'' }}>{{ $cat->name_ar }}</option>
                      @endforeach
                    </select>
                  </div>
                </div> --}}
                {{-- <div class="col-md-3">
                  <p>
                    <b>ظهور الخبر في</b>
                  </p>
                  <div class="form-group default-select select2Style">
                    <select class="form-control select2" name="special_id" data-placeholder="Select">
                      <option value="1">السلايدر + الرئيسية + الاقسام الداخلية</option>
                      <option value="2" {{ $news->special_id==2?'selected':'' }}>الرئيسية + الاقسام الداخلية</option>
                      <option value="3" {{ $news->special_id==3?'selected':'' }}>الاقسام الداخلية فقط</option>
                    </select>
                  </div>
                </div> --}}
                
                {{-- <div class="col-md-2">
                  <p>
                    <b>تفعيل التعليقات</b>
                  </p>
                  <div class="form-group default-select select2Style">
                    <select class="form-control select2" name="allow_comments" data-placeholder="Select">
                      <option value="1">نعم</option>
                      <option value="0" {{ $news->allow_comments==0?'selected':'' }}>لا</option>
                    </select>
                  </div>
                </div> --}}
                {{-- <div class="col-md-3">
                  <p>
                    <b>ظهور في الشريط المتحرك</b>
                  </p>
                  <div class="form-group default-select select2Style">
                    <select class="form-control select2" name="show_newsline" data-placeholder="Select">
                      
                      <option value="1">نعم</option>
                      <option value="0" {{ $news->show_newsline==0?'selected':'' }}>لا</option>
                      
                    </select>
                  </div>
                </div> --}}
                {{-- <div class="col-md-2">
                  <p>
                    <b>مثبت في اختيار المحرر</b>
                  </p>
                  <div class="form-group default-select select2Style">
                    <select class="form-control select2" name="is_writer_choice" data-placeholder="Select">
                      <option value="0">لا</option>
                      <option value="1" {{ $news->is_writer_choice==1?'selected':'' }}>نعم</option>
                    </select>
                  </div>
                </div> --}}
                {{-- <div class="col-sm-4">
                  <div class="form-group">
                    <div class="form-line">
                      <label for="email_address">تاريخ ووقت النشر</label>
                      <input id="myDateTimePicker" type="datetime" name="publish_up" value="{{ $news->created_at }}">


                    </div>
                  </div>
                </div> --}}

                {{-- <div class="col-md-3">
                  <p>
                    <b>حالة النشر</b>
                  </p>
                  <div class="demo-switch">
                    <div class="switch">
                      <label>منشور
                        <input type="checkbox" name="is_active" {{ $news->is_active==1?'checked':'' }}>
                        <span class="lever"></span>مسودة</label>
                    </div>
                  </div>
                </div> --}}
                {{-- meta data --}}
                <div style="background: rgb(215, 249, 255);">
                  <div class="col-md-12">
                    <div class="form-group form-float">
                      <div class="form-line">
                        <input type="text" class="form-control" name="slug"
                          placeholder="URL Meta (اذا ترك فارغاً سيتم اعتماد عنوان الخبر)"
                          value="{{ $news->slug }}">
                        {{-- <label class="form-label">عنوان Meta </label> --}}
                        @if ($errors->has('slug'))
                          <label class="alert alert-danger">{{ $errors->first('slug') }}</label>
                        @endif
                      </div>
                    </div>
                  </div>
                  <div class="col-md-12">
                    <div class="form-group form-float">
                      <div class="form-line">
                        <input type="text" class="form-control" name="meta_title"
                          placeholder="عنوان Meta (اذا ترك فارغاً سيتم اعتماد عنوان الخبر)"
                          value="{{ $news->meta_title }}">
                        {{-- <label class="form-label">عنوان Meta </label> --}}
                        @if ($errors->has('meta_title'))
                          <label class="alert alert-danger">{{ $errors->first('meta_title') }}</label>
                        @endif
                      </div>
                    </div>
                  </div>
                  <div class="col-md-12">
                    <div class="form-group form-float">
                      <div class="form-line">
                        <textarea class="tinymcexxx" name="meta_description"
                          placeholder="وصف Meta: اذا ترك فارغاً سيتم اعتماد جزء من تفاصيل الخبر" style="height: 100px;">{{ $news->meta_description }}</textarea>
                        {{-- <label class="form-label"> وصف Meta</label> --}}
                        @if ($errors->has('meta_description'))
                          <label class="alert alert-danger">{{ $errors->first('meta_description') }}</label>
                        @endif
                      </div>
                    </div>
                  </div>
                  <div class="col-md-12">
                    <div class="card">
                      <div class="header">
                        <label class="form-label">كلمات مفتاحية (هاشتاغ)</label>
                      </div>
                      <div class="body">
                        <div class="form-group demo-tagsinput-area">
                          <div class="form-line">
                            <input type="text" name="tags[]" class="form-control" data-role="tagsinput" value="@foreach (explode(',',$news->tags) as $tgname){{ $tgname.',' }}@endforeach" placeholder="أضف كلمة ثم انقر enter">
                            {{-- <select class="form-control" id="select2-rtl-multiple" name="tags[]" multiple="multiple">
                              <optgroup label="">
                                @foreach ($tags as $tag)
                                <option value="{{ $tag->id }}"
                                  @foreach (explode(',',$news->tags) as $tgname) {{ $tgname==$tag->name?'selected':'' }} @endforeach>{{ $tag->name }}</option>
                                @endforeach
                            </optgroup>
                            </select> --}}
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                {{-- meta data --}}

                <button class="btn btn-primary waves-effect" type="submit">{{ __('messages.UPDATE') }}</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
@endsection
@push('plugin_js')
<script src="{{ asset('BackEnd/js/form.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/bundles/multiselect/js/jquery.multi-select.js') }}"></script>
<script src="{{ asset('BackEnd/js/bundles/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.js') }}"></script>
@endpush
@push('custom_js')
<script src="{{ asset('BackEnd/js/pages/forms/basic-form-elements.js') }}"></script>
<script src="{{ asset('BackEnd/js/tinymce/js/tinymce/tinymce.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/tinymce/js/tinymce/jquery.tinymce.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/pages/forms/advanced-form-elements.js') }}"></script>
<script src="https://cdn.tiny.cloud/1/b96ob2jubh2z0uymimy4flro5olk1fzaxgjxnv22tb59kux9/tinymce/7/tinymce.min.js" referrerpolicy="origin"></script>

@endpush

@push('tinymce')
<script>
  $(document).ready(function() {
    $('#category_id').on('change', function() {
      $('#subcategory_id').empty();
      $.getJSON("/eco_panel/get_sub_categories/" + $(this).val(), function(data) {
        $('#subcategory_id').show();
        $.each(data, function(index, item) {
          $('#subcategory_id').append(
            $('<option></option>').val(item["id"]).html(item["name"])
          );
        });
      });
    });
    $('#add_image').on('click',function(){
    $('#gallery-content').append('<div class="col-md-12">\
      <div class="file-field input-field">\
        <div class="btn">\
          <span>صورة اضافية</span>\
          <input type="file" name="gallery[]">\
        </div>\
        <div class="file-path-wrapper">\
          <input class="file-path validate" type="text" name="gallery[]" placeholder="انقر لاختيار صورة اضافية للخبر">\
          @if ($errors->has('gallery'))\
          <label class="alert alert-danger">{{ $errors->first('gallery') }}</label>\
          @endif\
        </div>\
        <div class="form-check m-l-10">\
          <label class="form-check-label">\
            <input class="form-check-input" type="checkbox" id="checkbox" name="icon">\
            إضافة الشعار إلى الصورة\
            <span class="form-check-sign">\
              <span class="check"></span>\
            </span>\
          </label>\
        </div>\
      </div>\
    </div>');
    });
    $('#minus_button').on('click',function(){
    $('#gallery-content').children("div").last().remove();
    });

    tinymce.init({
        selector: 'textarea.tinymce',
        plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
        toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
        language: 'ar',
        height: 500,
        relative_urls: true,
        document_base_url: '//www.tiny.cloud/docs/demo',
        image_title: true,
        automatic_uploads: true,
        images_upload_url: '/upload',
        file_picker_types: 'image',
        file_picker_callback: function(cb, value, meta) {
          var input = document.createElement('input');
          input.setAttribute('type', 'file');
          input.setAttribute('accept', 'image/*');
          input.onchange = function() {
            var file = this.files[0];

            var reader = new FileReader();
            reader.readAsDataURL(file);
            reader.onload = function() {
              var id = 'blobid' + (new Date()).getTime();
              var blobCache = tinymce.activeEditor.editorUpload.blobCache;
              var base64 = reader.result.split(',')[1];
              var blobInfo = blobCache.create(id, file, base64);
              blobCache.add(blobInfo);
              cb(blobInfo.blobUri(), {
                title: file.name
              });
            };
          };
          input.click();
        }
      });
  });

</script>
@endpush
