@extends('BackEnd.Layouts.main')
@section('title')
  {{ __('messages.View News') }}
@endsection
@section('content')
  <section class="content">
    <div class="container-fluid">
      @include('BackEnd.Layouts.breadcrumb')
      @if (session('success'))
        <div class="alert alert-success text-center">
          {{ session('success') }}
        </div>
      @endif
      @if (session('error'))
        <div class="alert alert-danger text-center">
          {{ session('error') }}
        </div>
      @endif

      <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
          <div class="card">
            @include('BackEnd.Layouts.tableheader')
            <div class="body">
              <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover save-stage dataTable" style="width:100%;">
                  <thead>
                    <tr>
                      <th>م</th>
                      <th style="width:250px;display:block;height: 63px;">عنوان الخبر</th>
                      <th>القسم الرئيسي</th>
                      <th>القسم الفرعي</th>
                      {{-- @ability(['admin','super_admin'],['']) --}}
                      <th>الحالة</th>
                      {{-- @endability --}}
                      <th>{{ __('messages.VIEWS') }}</th>
                      {{-- <th>التعليقات</th> --}}
                      <th>{{ __('messages.PUBLISHED_DATE') }}</th>
                      <th>المحرر</th>
                      <th>آخر تعديل بواسطة</th>
                      <th>{{ __('messages.CONTROL') }}</th>
                    </tr>
                  </thead>
                  <tbody>
                    @foreach ($news as $new)
                      <tr id="{{ $new->id }}" class="{{ $editor==$new->is_active?'alert alert-warning':'' }}" >
                        <td>{{ $new->id }}</td>
                        <td>{{ $new->subtitle }}<br>
                          <a href="{{ route('news_cat_details', [$new->getCategory->slug, $new->slug]) }}"
                            target="_blank">{{ $new->title }}</a>
                        </td>
                        <td>{{ $new->getCategory->name }}</td>
                        <td>{{ $new->subcategory_id == 0 ? '' : $new->getSubcategory->name }}</td>
                        {{-- @ability(['admin','super_admin'],['']) --}}
                        <td>
                          {{-- {{auth()->user()->type}} {{$editor.'=='.$new->is_active}} --}}
                          <a href="{{ route('news.edit', $new->id) }}" title="{{ $new->is_active == 4 ? 'انقر للمراجعة الاولى' : ($new->is_active == 3 ? 'انقر للمراجعة اللغوية' : ($new->is_active == 2 ? 'انقر للموافقة على النشر' : ($new->is_active == 1 ? 'منشور' : 'مسودة'))) }}"><button type="button"
                            class="btn btn-outline-{{ $new->is_active == 4 ? 'danger' : ($new->is_active == 3 ? 'warning' : ($new->is_active == 2 ? 'info' : ($new->is_active == 1 ? 'success' : 'dark'))) }} waves-effect waves-float">
                            <i class="material-icons">
                              {{ $new->is_active == 4 ? 'info_outline' : ($new->is_active == 3 ? 'spellcheck' : ($new->is_active == 2 ? 'done' : ($new->is_active == 1 ? 'done_all' : 'error'))) }} <span style="font-family: 'slcmedium';color:black;font-size:xx-small">{{ $new->is_active == 4 ? 'للمراجعة الاولى' : ($new->is_active == 3 ? 'للمراجعة اللغوية' : ($new->is_active == 2 ? 'للموافقة على النشر' : ($new->is_active == 1 ? 'منشور' : 'مسودة'))) }}</span>
                            </i></a>

                    </td>

                    {{-- @endability --}}
                    <td>{{ $new->views }}</td>
                    {{-- <td>0</td> --}}
                    <td><span style="font-size:xx-small">
                        {{ $new->created_at->toDateString() }}</span><br>
                      {{ $new->created_at->toTimeString() }}</td>
                    <td>{{ $new->getUser->name ?? '' }}</td>
                    <td>{{ $new->getEditor->name ?? '' }}</td>
                    <td>

                      <a href="{{ route('news.edit', $new->id) }}" style="color: white"><button type="button"
                          class="btn btn-info btn-circle waves-effect waves-circle waves-float">
                          <i class="material-icons">mode_edit</i></a>
                      </button>
                      {{-- @ability(['publisher','admin','super_admin'],['']) --}}
                      {{-- @php
                        if(auth()->user()->id==$new->created_by){
                        $user_ability = 1;
                        }elseif($user->roles()->get()->first()->id==1){
                        $user_ability = 1;
                        }elseif($user->roles()->get()->first()->id==2){
                        $user_ability = 1;
                        }else{
                        $user_ability = 0;
                        }
                        @endphp --}}
                      @if (true)
                        <button type="button"
                          class="delete btn btn-danger btn-circle waves-effect waves-circle waves-float"
                          id="{{ $new->id . ',' . $new->title . ',' . __('messages.Are you sure you want to delete the row named:') }}">
                          <i class="material-icons">delete</i>
                        </button>
                      @endif
                      {{-- @endability --}}
                    </td>
                    </tr>
                    @endforeach
                  </tbody>
                </table>
                {{ $news->links() }}
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">{{ __('messages.Confirm Deletion') }}</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body" id='modal_content'>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-info waves-effect" id="delete_btn">{{ __('messages.YES') }}</button>
          {{-- <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal">{{ __('messages.NO') }}</button> --}}
        </div>
      </div>
    </div>
  </div>
@endsection
@push('plugin_js')
  {{-- <script src="{{ asset('BackEnd/js/table.min.js') }}"></script> --}}
@endpush
@push('custom_js')
  {{-- <script src="{{ asset('BackEnd/js/pages/tables/jquery-datatable.js') }}"></script> --}}
@endpush

@push('is_active_ajax')
  <script>
    $(document).ready(function() {
      $('.is_active').on('click', function() {
        var $new_id = $(this).attr('id');
        // alert($new_id);
        $.getJSON("/eco_panel/news/status/" + $new_id, function(data) {
          $.each(data, function(index, item) {
            if (item == 1)
              $('#span-' + $new_id).html('<span style="color:#29b474">منشور</span>');
            if (item == -1)
              $('#span-' + $new_id).html('<span style="color:#eb5757">غير منشور</span>');
          });
        });
      });

      var del;
      $('.delete').on('click', function() {
        del = $(this).attr('id').split(',');
        $('#deleteModal').modal('show');
        $('#modal_content').html(del[2] + "<br>\
              <p class='alert alert-warning modal__text'>" + del[1] + " </p>");
        $('.modal__btns').show();
      });
      $('#delete_btn').on('click', function() {
        $.getJSON("/eco_panel/news/delete/" + del[0], function(data) {
          $('#modal_content').html("<p class='alert alert-warning'> تم الحذف بنجاح <p>");
          $('.modal__btns').hide();
          $('#deleteModal').modal('toggle');
          $('#' + del[0] + '').fadeOut(1500);
        });
      });
    });
  </script>
@endpush
