@extends('BackEnd.Layouts.main')
@section('title')
  {{ __('messages.DASHBOARD_MAIN') }}
@endsection

@section('content')
  @if (session('success'))
    <div class="getback_message success">
      {{ session('success') }}
    </div>
  @endif
  @if (session('error'))
    <div class="getback_message error">
      {{ session('error') }}
    </div>
  @endif

  <section class="content">
    <div class="container-fluid">
      @include('BackEnd.Layouts.breadcrumb')
      <!-- Widgets -->
      <div class="row">
        @role('manage_news|super_admin')
          <div class="col-lg-3 col-sm-6">
            <div class="counter-box text-center white">
              <a href="{{ route('news.index') }}">
                <div class="text font-17 m-b-5">الأخبار</div>
              </a>
              <h1 class="m-b-10 m-t-0">{{ $news_count }}</h1>
            </div>
          </div>
        @endrole
        @role('manage_breakingnews|super_admin')
          <div class="col-lg-3 col-sm-6">
            <div class="counter-box text-center white">
              <a href="{{ route('breakingnews.index') }}">
                <div class="text font-17 m-b-5">الأخبار العاجلة</div>
              </a>
              <h1 class="m-b-10 m-t-0">{{ $breakingnews_count }}</h1>
            </div>
          </div>
        @endrole
        @role('manage_articles|super_admin')
          <div class="col-lg-3 col-sm-6">
            <div class="counter-box text-center white">
              <a href="{{ route('articles.index') }}">
                <div class="text font-17 m-b-5">المقالات</div>
              </a>
              <h1 class="m-b-10 m-t-0">{{ $articles_count }}</h1>
            </div>
          </div>
        @endrole
        @role('manage_writers|super_admin')
          <div class="col-lg-3 col-sm-6">
            <div class="counter-box text-center white">
              <a href="{{ route('writers.index') }}">
                <div class="text font-17 m-b-5">الكتّاب</div>
              </a>
              <h1 class="m-b-10 m-t-0">{{ $writers_count }}</h1>
            </div>
          </div>
        @endrole
        @role('manage_comments|super_admin')
          <div class="col-lg-3 col-sm-6">
            <div class="counter-box text-center white">
              <div class="text font-17 m-b-5">التعليقات</div>
              <div class="row">
                <div class="col-6">
                  <a href="{{ route('comments.news') }}">
                    <div class="text font-17 m-b-5">الأخبار</div>
                  </a>
                  <h1 class="m-b-10 m-t-0">{{ $news_comments_count }}</h1>
                </div>
                <div class="col-6">
                  <a href="{{ route('comments.articles') }}">
                    <div class="text font-17 m-b-5">المقالات</div>
                  </a>
                  <h1 class="m-b-10 m-t-0">{{ $articles_comments_count }}</h1>
                </div>
              </div>
            </div>
          </div>
        @endrole
        @role('manage_photos|super_admin')
          <div class="col-lg-3 col-sm-6">
            <div class="counter-box text-center white">
              <a href="{{ route('newspapers.index') }}">
                <div class="text font-17 m-b-5">الصحيفة المطبوعة</div>
              </a>
              <h1 class="m-b-10 m-t-0">{{ $newspapers_count }}</h1>
            </div>
          </div>
        @endrole
        @role('manage_photos|super_admin')
          <div class="col-lg-3 col-sm-6">
            <div class="counter-box text-center white">
              <a href="{{ route('photos.index') }}">
                <div class="text font-17 m-b-5">الصور</div>
              </a>
              <h1 class="m-b-10 m-t-0">{{ $photos_count }}</h1>
            </div>
          </div>
        @endrole
        @role('manage_videos|super_admin')
          <div class="col-lg-3 col-sm-6">
            <div class="counter-box text-center white">
              <a href="{{ route('videos.index') }}">
                <div class="text font-17 m-b-5">الفيديو</div>
              </a>
              <h1 class="m-b-10 m-t-0">{{ $videos_count }}</h1>
            </div>
          </div>
        @endrole
        @role('manage_caricature|super_admin')
          <div class="col-lg-3 col-sm-6">
            <div class="counter-box text-center white">
              <a href="{{ route('infographic.index') }}">
                <div class="text font-17 m-b-5">الانفوجرافيك</div>
              </a>
              <h1 class="m-b-10 m-t-0">{{ $infographic_count }}</h1>
            </div>
          </div>
        @endrole
        @role('manage_users|super_admin')
          <div class="col-lg-3 col-sm-6">
            <div class="counter-box text-center white">
              <a href="{{ route('users.index') }}">
                <div class="text font-17 m-b-5">المحررين</div>
              </a>
              <h1 class="m-b-10 m-t-0">{{ $users_count }}</h1>
            </div>
          </div>
        @endrole
        @role('manage_polls|super_admin')
          <div class="col-lg-3 col-sm-6">
            <div class="counter-box text-center white">
              <a href="{{ route('polls.index') }}">
                <div class="text font-17 m-b-5">الاستطلاعات</div>
              </a>
              <h1 class="m-b-10 m-t-0">{{ $polls_count }}</h1>
            </div>
          </div>
        @endrole
        @role('manage_pages|super_admin')
          <div class="col-lg-3 col-sm-6">
            <div class="counter-box text-center white">
              <a href="{{ route('pages.index') }}">
                <div class="text font-17 m-b-5">المحتويات</div>
              </a>
              <h1 class="m-b-10 m-t-0">{{ $pages_count }}</h1>
            </div>
          </div>
        @endrole
        @role('manage_ads|super_admin')
          <div class="col-lg-3 col-sm-6">
            <div class="counter-box text-center white">
              <a href="{{ route('ads.index') }}">
                <div class="text font-17 m-b-5">الاعلانات</div>
              </a>
              <h1 class="m-b-10 m-t-0">{{ $ads_count }}</h1>
            </div>
          </div>
        @endrole
        @role('manage_categories|super_admin')
          <div class="col-lg-3 col-sm-6">
            <div class="counter-box text-center white">
              <a href="{{ route('categories.index') }}">
                <div class="text font-17 m-b-5">الأقسام</div>
              </a>
              <h1 class="m-b-10 m-t-0">{{ $categories_count }}</h1>
            </div>
          </div>
        @endrole
        @role('manage_newsletters|super_admin')
          <div class="col-lg-3 col-sm-6">
            <div class="counter-box text-center white">
              <a href="{{ route('newsletters.index') }}">
                <div class="text font-17 m-b-5">القائمة البريدية</div>
              </a>
              <h1 class="m-b-10 m-t-0">{{ $newsletters_count }}</h1>
            </div>
          </div>
        @endrole
        @role('manage_categories|super_admin')
          <div class="col-lg-3 col-sm-6">
            <div class="counter-box text-center white">
              <a href="{{ route('contacts.index') }}">
                <div class="text font-17 m-b-5">الرسائل</div>
              </a>
              <h1 class="m-b-10 m-t-0">{{ $contacts_count }}</h1>
            </div>
          </div>
        @endrole
      </div>
      <!-- #END# Widgets -->
    </div>
  </section>
@endsection
@push('plugin_js')
  <script src="assets/js/chart.min.js"></script>
@endpush
@push('custom_js')
  <script src="assets/js/pages/sparkline/sparkline-data.js"></script>
  <script src="assets/js/bundles/apexcharts/apexcharts.min.js"></script>
  <script src="assets/js/pages/index.js"></script>
@endpush
