@extends('BackEnd.Layouts.main')
@section('title')
  عرض الرسائل
@endsection
@section('content')
  <section class="content">
    <div class="container-fluid">
      @include('BackEnd.Layouts.breadcrumb')
      @if (session('success'))
        <div class="alert alert-success text-center">
          {{ session('success') }}
        </div>
      @endif
      @if (session('error'))
        <div class="alert alert-danger text-center">
          {{ session('error') }}
        </div>
      @endif

      <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
          <div class="card">
            @include('BackEnd.Layouts.tableheader')
            <div class="body">
              <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover save-stage dataTable" style="width:100%;">
                  <thead>
                    <tr>
                      <th>م</th>
                      <th>المرسل</th>
                      <th>الرسالة</th>
                      <th>تاريخ الارسال</th>
                      <th>{{ __('messages.CONTROL') }}</th>
                    </tr>
                  </thead>
                  <tbody>
                    @foreach ($contacts as $contact)
                      <tr id="{{ $contact->id }}">
                        <td>{{ $loop->iteration }}</td>
                        <td>
                          {{ $contact->name ?? '' }}<br>
                          {{ $contact->phone ?? '' }}<br>
                          {{ $contact->email ?? '' }}<br>
                        </td>
                        <td><span style="color: green;">{{ $contact->subject }}</span><br>
                          {{ $contact->message }}</td>
                        <td><span style="font-size:xx-small">
                            {{ $contact->created_at->toDateString() }}</span><br>
                          {{ $contact->created_at->toTimeString() }}</td>
                        <td>
                          {{-- <a href="{{ route('contacts.edit',$contact->id) }}" style="color: white"><button type="button" class="btn btn-info btn-circle waves-effect waves-circle waves-float">
                            <i class="material-icons">mode_edit</i></a>
                        </button> --}}
                          @if (true)
                            <button type="button"
                              class="delete btn btn-danger btn-circle waves-effect waves-circle waves-float"
                              id="{{ $contact->id . ',' . $contact->name . ',' . __('messages.Are you sure you want to delete the row named:') }}">
                              <i class="material-icons">delete</i>
                            </button>
                          @endif
                        </td>
                      </tr>
                    @endforeach
                  </tbody>
                </table>
                {{ $contacts->links() }}
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">{{ __('messages.Confirm Deletion') }}</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body" id='modal_content'>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-info waves-effect" id="delete_btn">{{ __('messages.YES') }}</button>
          {{-- <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal">{{ __('messages.NO') }}</button> --}}
        </div>
      </div>
    </div>
  </div>
@endsection
@push('plugin_js')
  {{-- <script src="{{ asset('BackEnd/js/table.min.js') }}"></script> --}}
@endpush
@push('custom_js')
  {{-- <script src="{{ asset('BackEnd/js/contacts/tables/jquery-datatable.js') }}"></script> --}}
@endpush

@push('is_active_ajax')
  <script>
    $(document).ready(function() {
      $('.is_active').on('click', function() {
        var $contact_id = $(this).attr('id');
        // alert($contact_id);
        $.getJSON("/eco_panel/contacts/status/" + $contact_id, function(data) {
          $.each(data, function(index, item) {
            if (item == 1)
              $('#span-' + $contact_id).html('<span style="color:#29b474">منشور</span>');
            if (item == -1)
              $('#span-' + $contact_id).html('<span style="color:#eb5757">غير منشور</span>');
          });
        });
      });

      var del;
      $('.delete').on('click', function() {
        del = $(this).attr('id').split(',');
        $('#deleteModal').modal('show');
        $('#modal_content').html(del[2] + "<br>\
          <p class='alert alert-warning modal__text'>" + del[1] + " </p>");
        $('.modal__btns').show();
      });
      $('#delete_btn').on('click', function() {
        $.getJSON("/eco_panel/contacts/delete/" + del[0], function(data) {
          $('#modal_content').html("<p class='alert alert-warning'> تم الحذف بنجاح <p>");
          $('.modal__btns').hide();
          $('#deleteModal').modal('toggle');
          $('#' + del[0] + '').fadeOut(1500);
        });
      });
    });
  </script>
@endpush
