@extends('BackEnd.Layouts.main')
@section('title')
عرض التعليقات
@endsection
@section('content')
<section class="content">
  <div class="container-fluid">
    @include('BackEnd.Layouts.breadcrumb')
      @if(session('success'))
      <div class="alert alert-success text-center">
        {{session("success")}}
      </div>
      @endif
      @if(session('error'))
      <div class="alert alert-danger text-center">
        {{ session('error') }}
      </div>
      @endif

    <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
          @include('BackEnd.Layouts.tableheader')
          <div class="body">
            <div class="table-responsive">
              <table class="table table-bordered table-striped table-hover save-stage dataTable" style="width:100%;">
                <thead>
                  <tr>
                    <th>م</th>
                    <th>المعلق</th>
                    <th>نص التعليق</th>
                    <th>عنوان الخبر</th>
                    {{-- @ability(['admin','super_admin'],['']) --}}
                    <th>الحالة</th>
                    {{-- @endability --}}
                    {{-- <th>{{ __('messages.VIEWS') }}</th> --}}
                    <th>تاريخ الاضافة</th>
                    {{-- <th>المحرر</th> --}}
                    <th>آخر تعديل بواسطة</th>
                    <th>{{ __('messages.CONTROL') }}</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach ($comments as $comment)
                    <tr id="{{ $comment->id }}">
                      <td>{{ $loop->iteration }}</td>
                      <td>
                        {{ $comment->name }}<br>
                        {{ $comment->phone }}<br>
                        {{ $comment->email }}<br>
                      </td>
                      <td>{{ $comment->comment }}</td>
                      <td><a href="{{ route('news_cat_details', [$comment->getNews->getCategory->name, $comment->getNews->slug]) }}" target="_blank">{{ $comment->getNews->title??'' }}</a></td>
                      {{-- <td><a href="#" target="_blank">{{ $comment->getNews->title??'' }}</a></td> --}}
                      {{-- @ability(['admin','super_admin'],['']) --}}
                      <td><button type="button" id="{{ $comment->id }}" class="is_active btn btn-outline-{{ $comment->is_active==1?'success':'warning' }} btn-border-radius"><span id="span-{{ $comment->id }}">{{ $comment->is_active==1? __('messages.PUBLISHED') : __('messages.UNPUBLISHED') }}</span></button></td>
                      {{-- @endability --}}
                      {{-- <td>{{ $comment->views }}</td> --}}
                      <td><span style="font-size:xx-small">
                        {{ $comment->created_at->toDateString() }}</span><br>
                        {{ $comment->created_at->toTimeString() }}</td>
                    {{-- <td>{{ $comment->getUser->name??'' }}</td> --}}
                    <td>{{ $comment->getEditor->name??'' }}</td>
                      <td>
                        {{-- <a href="#" target="_blank"><button type="button" class="btn btn-warning btn-circle waves-effect waves-circle waves-float">
                            <i class="material-icons">visibility</i>
                          </button></a> --}}
                        <a href="{{ route('comments.edit',$comment->id) }}" style="color: white"><button type="button" class="btn btn-info btn-circle waves-effect waves-circle waves-float">
                            <i class="material-icons">mode_edit</i></a>
                        </button>
                        {{-- @ability(['publisher','admin','super_admin'],['']) --}}
                        @if(true)
                        <button type="button" class="delete btn btn-danger btn-circle waves-effect waves-circle waves-float" id="{{ $comment->id.','.$comment->name.','. __('messages.Are you sure you want to delete the row named:') }}">
                            <i class="material-icons">delete</i>
                        </button>
                        @endif
                        {{-- @endability --}}
                      </td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
              {{ $comments->links() }}
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">{{ __('messages.Confirm Deletion') }}</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body" id='modal_content'>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-info waves-effect" id="delete_btn">{{ __('messages.YES') }}</button>
        {{-- <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal">{{ __('messages.NO') }}</button> --}}
      </div>
    </div>
  </div>
</div>
@endsection
@push('plugin_js')
{{-- <script src="{{ asset('BackEnd/js/table.min.js') }}"></script> --}}
@endpush
@push('custom_js')
{{-- <script src="{{ asset('BackEnd/js/comments/tables/jquery-datatable.js') }}"></script> --}}
@endpush

@push('is_active_ajax')
  <script>
    $(document).ready(function () {
      $('.is_active').on('click',function(){
        var $comment_id = $(this).attr('id');
        // alert($comment_id);
        $.getJSON("/eco_panel/comments/status/" + $comment_id, function(data) {
          $.each(data, function(index, item) {
            if(item==1)
            $('#span-'+$comment_id).html('<span style="color:#29b474">منشور</span>');
            if(item==-1)
            $('#span-'+$comment_id).html('<span style="color:#eb5757">غير منشور</span>');
          });
        });
      });

      var del;
      $('.delete').on('click',function(){
        del = $(this).attr('id').split(',');
        $('#deleteModal').modal('show');
        $('#modal_content').html(del[2]+"<br>\
        <p class='alert alert-warning modal__text'>"+del[1]+" </p>");
        $('.modal__btns').show();
      });
      $('#delete_btn').on('click', function() {
        $.getJSON("/eco_panel/comments/delete/" + del[0], function(data) {
          $('#modal_content').html("<p class='alert alert-warning'> تم الحذف بنجاح <p>");
            $('.modal__btns').hide();
            $('#deleteModal').modal('toggle');
            $('#'+del[0]+'').fadeOut(1500);
        });
      });
    });
  </script>
@endpush
