@extends('BackEnd.Layouts.main')
@section('title')
تعديل تعليق
@endsection

@section('content')

<section class="content">
  <div class="container-fluid">
    {{-- @include('BackEnd.Layouts.breadcrumb') --}}
    @if(session('success'))
    <div class="alert alert-success text-center">
      {{session("success")}}
    </div>
    @endif
    @if(session('error'))
    <div class="alert alert-danger text-center">
      {{ session('error') }}
    </div>
    @endif

    <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
          {{-- @include('BackEnd.Layouts.tableheader') --}}
          <div class="body">
            <form id="form_validation" method="POST" action="{{ route('commentarticles.update',$comment->id) }}" enctype="multipart/form-data">
              @csrf
              <div class="row">
                <div class="col-md-4">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="name" value="{{ $comment->name }}" required>
                      <label class="form-label">الاسم</label>
                      @if ($errors->has('name'))
                      <label class="alert alert-danger">{{ $errors->first('name') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="phone" value="{{ $comment->phone }}" required>
                      <label class="form-label">التلفون</label>
                      @if ($errors->has('phone'))
                      <label class="alert alert-danger">{{ $errors->first('phone') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="email" class="form-control" name="email" value="{{ $comment->email }}" required>
                      <label class="form-label">البريد الالكتروني</label>
                      @if ($errors->has('email'))
                      <label class="alert alert-danger">{{ $errors->first('email') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <textarea class="tinymcexx" name="comment" placeholder="نص التعليق" style="height: 300px">{{ $comment->comment }}</textarea>
                      {{-- <label class="form-label">نص التعليق</label> --}}
                      @if ($errors->has('comment'))
                      <label class="alert alert-danger">{{ $errors->first('comment') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-md-3">
                  <p>
                    <b>حالة النشر</b>
                  </p>
                  <div class="demo-switch">
                    <div class="switch">
                      <label>منشور
                        <input type="checkbox" name="is_active" {{ $comment->is_active==1?'checked':'' }}>
                        <span class="lever"></span>مسودة</label>
                    </div>
                  </div>
                </div>
                <button class="btn btn-primary waves-effect" type="submit">{{ __('messages.UPDATE') }}</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>



@endsection
@push('plugin_js')
<script src="{{ asset('BackEnd/js/form.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/bundles/multiselect/js/jquery.multi-select.js') }}"></script>
<script src="{{ asset('BackEnd/js/bundles/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.js') }}"></script>
@endpush
@push('custom_js')
<script src="{{ asset('BackEnd/js/comments/forms/basic-form-elements.js') }}"></script>
<script src="{{ asset('BackEnd/js/tinymce/js/tinymce/tinymce.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/tinymce/js/tinymce/jquery.tinymce.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/comments/forms/advanced-form-elements.js') }}"></script>
@endpush

@push('tinymce')
<script>
  $(document).ready(function() {
    $('#add_image').on('click', function() {
      $('#gallery-content').append('<div class="col-md-12">\
      <div class="file-field input-field">\
        <div class="btn">\
          <span>صورة اضافية</span>\
          <input type="file" name="gallery[]">\
        </div>\
        <div class="file-path-wrapper">\
          <input class="file-path validate" type="text" name="gallery[]" placeholder="انقر لاختيار صورة اضافية للخبر">\
          @if ($errors->has('
        gallery '))\
          <label class="alert alert-danger">{{ $errors->first('
        gallery ') }}</label>\
          @endif\
        </div>\
        <div class="form-check m-l-10">\
          <label class="form-check-label">\
            <input class="form-check-input" type="checkbox" id="checkbox" name="icon">\
            إضافة الشعار إلى الصورة\
            <span class="form-check-sign">\
              <span class="check"></span>\
            </span>\
          </label>\
        </div>\
      </div>\
    </div>');
    });
    $('#minus_button').on('click', function() {
      $('#gallery-content').children("div").last().remove();
    });

    $('textarea.tinymce').tinymce({
      toolbar_mode: 'scrolling'
      , plugins: [
        'advlist autolink link image lists charmap print preview hr anchor newsletterbreak'
        , 'searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking'
        , 'table emoticons template paste help'
      ]
      , toolbar: 'undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | ' +
        'bullist numlist outdent indent | link image | print preview media fullscreen | ' +
        'forecolor backcolor emoticons | help'
      , menubar: 'file edit view insert format tools table help',
      // content_css: 'css/content.css'

      language: 'ar'
      , height: 500
        // , width: 720
    , });
  });

</script>
@endpush
