@extends('BackEnd.Layouts.main')
@section('title')
{{ __('messages.Edit Category') }}
@endsection

@section('content')


<section class="content">
  <div class="container-fluid">
    @include('BackEnd.Layouts.breadcrumb')
    @if(session('success'))
    <div class="alert alert-success text-center">
      {{session("success")}}
    </div>
    @endif
    @if(session('error'))
    <div class="alert alert-danger text-center">
      {{ session('error') }}
    </div>
    @endif

    <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
          @include('BackEnd.Layouts.tableheader')
          <div class="body">
            <form id="form_validation" method="POST" action="{{ route('categories.update',$category->id) }}" enctype="multipart/form-data">
              @csrf
              <div class="row">
                <div class="col-md-10">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="name_ar" value="{{ $category->name_ar }}" required>
                      <label class="form-label">{{ __('messages.TITLE') }} ({{ __('messages.ARABIC') }})</label>
                      @if ($errors->has('name_ar'))
                      <label class="alert alert-danger">{{ $errors->first('name_ar') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                {{-- <input type="text" class="form-control" name="name_en" value="{{ $category->name }}"> --}}

                {{-- <div class="col-md-5">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="name_en" value="{{ json_decode($category->name,true)['en'] }}" required>
                      <label class="form-label">{{ __('messages.TITLE') }} ({{ __('messages.ENGLISH') }})</label>
                      @if ($errors->has('name_en'))
                      <label class="alert alert-danger">{{ $errors->first('name_en') }}</label>
                      @endif
                    </div>
                  </div>
                </div> --}}
                <div class="col-md-2">
                  <div class="form-group default-select select2Style">
                    <select class="form-control select2" name="parent_id" data-placeholder="حدد القسم">
                      <option value="0">رئيسي</option>
                      @foreach ($categories as $cat)
                      <option value="{{ $cat->id }}" {{ $cat->id==$category->parent_id?'selected':'' }}>{{ $cat->name_ar }}</option>
                      @endforeach
                    </select>
                  </div>
                </div>
                <div class="form-group">
                  <div class="form-check m-l-10">
                    <label class="form-check-label">
                      <input class="form-check-input" type="checkbox" id="checkbox" name="is_active" {{ $category->is_active==1?'checked':'' }}>
                      {{ __('messages.PUBLISHED') }}
                      <span class="form-check-sign">
                        <span class="check"></span>
                      </span>
                    </label>
                  </div>
                </div>
                <button class="btn btn-primary waves-effect" type="submit">{{ __('messages.UPDATE') }}</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>



@endsection
@push('plugin_js')
<script src="{{ asset('BackEnd/js/form.min.js') }}"></script>
@endpush
@push('custom_js')
<script src="{{ asset('BackEnd/js/pages/forms/basic-form-elements.js') }}"></script>
@endpush
