@extends('BackEnd.Layouts.main')
@section('title')
{{ __('messages.Add BreakingNews') }}
@endsection

@section('content')

<section class="content">
  <div class="container-fluid">
    @include('BackEnd.Layouts.breadcrumb')
      @if(session('success'))
      <div class="alert alert-success text-center">
        {{session("success")}}
      </div>
      @endif
      @if(session('error'))
      <div class="alert alert-danger text-center">
        {{ session('error') }}
      </div>
      @endif

    <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
          @include('BackEnd.Layouts.tableheader')
          <div class="body">
            <form id="form_validation" method="POST" action="{{ route('breakingnews.store') }}" enctype="multipart/form-data">
              @csrf
              <div class="row">
                <div class="col-md-12">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <textarea class="tinymce" name="name" placeholder="نص الخبر">{{ old('name') }}</textarea>
                      {{-- <label class="form-label">نص الخبر</label> --}}
                      @if ($errors->has('name'))
                      <label class="alert alert-danger">{{ $errors->first('name') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="url" value="{{ old('url') }}">
                      <label class="form-label">رابط الخبر (اختياري)</label>
                      @if ($errors->has('url'))
                      <label class="alert alert-danger">{{ $errors->first('url') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <input type="hidden" class="form-control" name="time" value="4320" required>
                {{-- <div class="col-md-12">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="number" class="form-control" name="time" value="{{ old('time') }}" required>
                      <label class="form-label">مدة العرض بالدقائق</label>
                      @if ($errors->has('time'))
                      <label class="alert alert-danger">{{ $errors->first('time') }}</label>
                      @endif
                    </div>
                  </div>
                </div> --}}
                <button class="btn btn-primary waves-effect" type="submit">{{ __('messages.Add') }}</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>


  </div>
</section>
@endsection
@push('plugin_js')
<script src="{{ asset('BackEnd/js/form.min.js') }}"></script>
@endpush
@push('custom_js')
<script src="{{ asset('BackEnd/js/pages/forms/basic-form-elements.js') }}"></script>
@endpush
