@extends('BackEnd.Layouts.main')
@section('title')
  {{ __('messages.View Books') }}
@endsection
@section('content')
  <section class="content">
    <div class="container-fluid">
      @include('BackEnd.Layouts.breadcrumb')
      @if (session('success'))
        <div class="alert alert-success text-center">
          {{ session('success') }}
        </div>
      @endif
      @if (session('error'))
        <div class="alert alert-danger text-center">
          {{ session('error') }}
        </div>
      @endif

      <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
          <div class="card">
            @include('BackEnd.Layouts.tableheader')
            <div class="body">
              <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover save-stage dataTable" style="width:100%;">
                  <thead>
                    <tr>
                      <th>م</th>
                      <th>{{ __('messages.NAME') }}</th>
                      @ability(['admin', 'super_admin'], [''])
                        <th>{{ __('messages.STATUS') }}</th>
                      @endability
                      <th><i class="material-icons">visibility</i></th>
                      <th><i class="material-icons">file_download</i></th>
                      <th>{{ __('messages.PUBLISHED_DATE') }}</th>
                      <th>إضافة</th>
                      <th>تعديل</th>
                      <th>{{ __('messages.CONTROL') }}</th>
                    </tr>
                  </thead>
                  <tbody>
                    @foreach ($books as $book)
                      <tr id="{{ $book->id }}">
                        <td>{{ $book->id }}</td>
                        <td>
                          <a href="#"
                            target="_blank">{{  $book->name }}</a></td>
                        
                        @ability(['admin', 'super_admin'], [''])
                          <td>
                            <button type="button" id="{{ $book->id }}"
                              class="is_active btn btn-outline-{{ $book->is_active == 1 ? 'success' : 'warning' }} btn-border-radius"><span
                                id="span-{{ $book->id }}" style="top: 0;">{{ $book->is_active == 1 ? __('messages.PUBLISHED') : __('messages.UNPUBLISHED') }}</span></button>
                          </td>
                        @endability
                        <td>{{ $book->views }}</td>
                        <td>{{ $book->downloads }}</td>
                        <td><span style="font-size:xx-small">
                            {{ $book->created_at->toDateString() }}</span><br>
                          {{ $book->created_at->toTimeString() }}</td>
                        <td>{{ $book->getUser->name ?? '' }}</td>
                        <td>{{ $book->getEditor->name ?? '' }}</td>
                        <td>
                          <a href="#" target="_blank"><button type="button"
                              class="btn btn-warning btn-circle waves-effect waves-circle waves-float">
                              <i class="material-icons">visibility</i>
                            </button></a>
                          <a href="{{ route('books.edit', $book->id) }}" style="color: white"><button type="button"
                              class="btn btn-info btn-circle waves-effect waves-circle waves-float">
                              <i class="material-icons">mode_edit</i></a>
                          </button>
                          @ability(['publisher', 'admin', 'super_admin'], [''])
                            @php
                              if (auth()->user()->id == $book->created_by) {
                                  $user_ability = 1;
                              } elseif (
                                  $user
                                      ->roles()
                                      ->get()
                                      ->first()->id == 1
                              ) {
                                  $user_ability = 1;
                              } elseif (
                                  $user
                                      ->roles()
                                      ->get()
                                      ->first()->id == 2
                              ) {
                                  $user_ability = 1;
                              } else {
                                  $user_ability = 0;
                              }
                            @endphp
                            @if ($user_ability > 0)
                              <button type="button"
                                class="delete btn btn-danger btn-circle waves-effect waves-circle waves-float"
                                id="{{ $book->id . ',' . $book->name . ',' . __('messages.Are you sure you want to delete the row named:') }}"><i
                                  class="material-icons">delete_forever</i></button>

                              <span class="is_favorite" id="{{ $book->id }}">
                                <span id="fav-{{ $book->id }}">

                                  {{-- <button type="button"
                                    class="btn btn-{{ $book->is_favorite == 1 ? 'success' : 'gray' }} btn-circle waves-effect waves-circle waves-float">

                                    <span>{!! $book->is_favorite == 1
                                        ? '<i class="material-icons">favorite</i>'
                                        : '<i class="material-icons">favorite_border</i>' !!}</span>
                                  </button> --}}


                                </span>
                              </span>
                            @endif
                          @endability
                        </td>
                      </tr>
                    @endforeach
                  </tbody>
                </table>
                {{ $books->links() }}
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">{{ __('messages.Confirm Deletion') }}</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body" id='modal_content'>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-info waves-effect" id="delete_btn">{{ __('messages.YES') }}</button>
          {{-- <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal">{{ __('messages.NO') }}</button> --}}
        </div>
      </div>
    </div>
  </div>
@endsection
@push('plugin_js')
  <script src="{{ asset('BackEnd/js/form.min.js') }}"></script>
  <script src="{{ asset('BackEnd/js/bundles/multiselect/js/jquery.multi-select.js') }}"></script>
  <script src="{{ asset('BackEnd/js/bundles/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.js') }}"></script>
@endpush
@push('custom_js')
  <script src="{{ asset('BackEnd/js/pages/forms/basic-form-elements.js') }}"></script>
  <script src="{{ asset('BackEnd/js/tinymce/js/tinymce/tinymce.min.js') }}"></script>
  <script src="{{ asset('BackEnd/js/tinymce/js/tinymce/jquery.tinymce.min.js') }}"></script>
  <script src="{{ asset('BackEnd/js/pages/forms/advanced-form-elements.js') }}"></script>
@endpush


@push('is_active_ajax')
  <script>
    $(document).ready(function() {

      $('.is_active').on('click', function() {
        var $book_id = $(this).attr('id');
        // alert($book_id);
        $.getJSON("/maad_panel/books/status/" + $book_id, function(data) {
          alert($book_id);
          $.each(data, function(index, item) {
            if (item == 1)
              $('#span-' + $book_id).html('<span style="color:#29b474">منشور</span>');
            if (item == -1)
              $('#span-' + $book_id).html('<span style="color:#eb5757">غير منشور</span>');
          });
        });
      });
      $('.show_home').on('click', function() {
        var $book_id = $(this).attr('id');
        // alert($book_id);
        $.getJSON("/maad_panel/books/show_home/" + $book_id, function(data) {
          // alert($book_id);
          $.each(data, function(index, item) {
            if (item == 1)
              $('#home-' + $book_id).html('<span style="color:#29b474"><i class="fa fa-home"></i></span>');
            if (item == -1)
              $('#home-' + $book_id).html('<span style="color:#eb5757"><i class="fa fa-home"></i></span>');
          });
        });
      });
      $('.is_favorite').on('click', function() {
        var $book_id = $(this).attr('id');
        // alert($book_id);
        $.getJSON("/maad_panel/books/favorite/" + $book_id, function(data) {
          $.each(data, function(index, item) {
            if (item == 1)
              $('#fav-' + $book_id).html(
                '<button type="button" class="btn btn-success btn-circle waves-effect waves-circle waves-float"><i class="material-icons">favorite</i></button>'
              );
            if (item == -1)
              $('#fav-' + $book_id).html(
                '<button type="button" class="btn btn-gray btn-circle waves-effect waves-circle waves-float"><i class="material-icons">favorite_border</i></button>'
              );
          });
        });
      });

      $('.books_part').on('click', function() {
        var auth_id = $(this).attr('id').split('-');
        $('#show_menu-' + auth_id[2]).show();
        $('#booksbyauthor-' + auth_id[2]).empty();
        $.getJSON("/maad_panel/get_books_by_author/" + auth_id[1], function(data) {
          $('#booksbyauthor-' + auth_id[2]).show();
          $.each(data, function(index, item) {
            $('#booksbyauthor-' + auth_id[2]).append(
              $('<option></option>').val(item["id"]).html(item["name"])
            );
          });
        });
      });

      var del;
      $('.delete').on('click', function() {
        del = $(this).attr('id').split(',');
        // alert(del[0]);
        // alert(del[1]);
        // alert(del[2]);
        $('#deleteModal').modal('show');
        $('#modal_content').html(del[2] + "<br>\
            <p class='alert alert-warning modal__text'>" + del[1] + " </p>");
        $('.modal__btns').show();
      });
      $('#delete_btn').on('click', function() {
        $.getJSON("/maad_panel/books/delete/" + del[0], function(data) {
          $('#modal_content').html("<p class='alert alert-warning'> تم الحذف بنجاح <p>");
          $('.modal__btns').hide();
          $('#deleteModal').modal('toggle');
          $('#' + del[0] + '').fadeOut(1500);
        });
      });
    });
  </script>
@endpush
