@extends('BackEnd.Layouts.main')
@section('title')
{{ __('messages.Add Book') }}
@endsection
@section('content')
<section class="content">
  <div class="container-fluid">
    @include('BackEnd.Layouts.breadcrumb')
    @if(session('success'))
    <div class="alert alert-success text-center">
      {{session("success")}}
    </div>
    @endif
    @if(session('error'))
    <div class="alert alert-danger text-center">
      {{ session('error') }}
    </div>
    @endif
    <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
          @include('BackEnd.Layouts.tableheader')
          <div class="body">
            <form id="form_validation" method="POST" action="{{ route('books.store') }}" enctype="multipart/form-data">
              @csrf
              <div class="row">

                <div class="col-md-8">
                  <div class="file-field input-field">
                    <div class="btn">
                      <span>ملف الكتاب</span>
                      <input type="file" name="pdf" id="book_file" class="book_file">
                    </div>
                    <div class="file-path-wrapper">
                      <input class="file-path validate" type="text" name="file" placeholder="يجب ان يكون الملف بتنسيق pdf" required>
                      @if ($errors->has('file'))
                      <label class="alert alert-danger">{{ $errors->first('file') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="file-field input-field">
                    <div class="btn">
                      <span>صورة الغلاف</span>
                      <input type="file" name="image">
                    </div>
                    <div class="file-path-wrapper">
                      <input class="file-path validate" type="text" name="image" placeholder="انقر لإضافة صورة " required>
                      @if ($errors->has('image'))
                      <label class="alert alert-danger">{{ $errors->first('image') }}</label>
                      @endif
                      {{-- <label for="form__img-upload">سيتم تكوينها من الغلاف تلقائياً</label> --}}
                    </div>
                  </div>
                </div>
                
                
                <div class="col-md-9">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" id="book_name" name="name" value="{{ old('name') }}" required>
                      <label class="form-label">اسم الكتاب</label>
                      @if ($errors->has('name'))
                      <label class="alert alert-danger">{{ $errors->first('name') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                {{-- <div class="col-md-3">
                  <div class="form-group default-select select2Style">
                    <select class="form-control select2" id="tags" name="tags_id" data-placeholder="Select" required>
                      <option>اختر التصنيف</option>
                      @foreach ($tags as $tag)
                      <option value="{{ $tag->id }}">{{ $tag->name }}</option>
                      @endforeach
                      <input type="hidden" id="tagname" name="tag_name">
                    </select>
                  </div>
                </div> --}}
                <div class="col-md-3" id="hide-details">
                  <div class="form-group" style="display: block">
                    <div class="form-check m-l-10">
                      <label class="form-check-label">
                        <input class="form-check-input" type="checkbox" id="add-details">
                        إضافة نبذة عن الكتاب
                        <span class="form-check-sign">
                          <span class="check"></span>
                        </span>
                      </label>
                    </div>
                  </div>
                </div>
                @ability(['super_admin'],[''])
                <div class="col-md-3">
                  <div class="form-group" style="display: block">
                    <div class="form-check m-l-10">
                      <label class="form-check-label">
                        <input class="form-check-input" type="checkbox" id="checkbox" name="is_active" checked>
                        {{ __('messages.PUBLISHED') }}
                        <span class="form-check-sign">
                          <span class="check"></span>
                        </span>
                      </label>
                    </div>
                  </div>
                </div>
                
                @endability

                <div id="show-details"></div>
                
                <button class="btn btn-primary waves-effect" type="submit">{{ __('messages.Add') }}</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
@endsection
@push('plugin_js')
<script src="{{ asset('BackEnd/js/form.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/bundles/multiselect/js/jquery.multi-select.js') }}"></script>
<script src="{{ asset('BackEnd/js/bundles/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.js') }}"></script>
@endpush
@push('custom_js')
<script src="{{ asset('BackEnd/js/pages/forms/basic-form-elements.js') }}"></script>
<script src="{{ asset('BackEnd/js/tinymce/js/tinymce/tinymce.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/tinymce/js/tinymce/jquery.tinymce.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/pages/forms/advanced-form-elements.js') }}"></script>
@endpush
@push('tinymce')
<script>
  $(document).ready(function() {

    $('#book_file').on('change', function() {
      var bkname = $(this).val().split('-');
      var bookname = bkname[0].trim();
      var bknamepure = bookname.substring(bookname.lastIndexOf("\\") + 1, bookname.length);
      $('#book_name').val(bknamepure);
      var authorname = bkname[1].trim();
      var authname = authorname.split('.');
      $('#authors').val(authname[0] + '2');
      $('#authorname').val(authname[0] + '2');
    });

    $('#authorname').keyup(function() {
      $('#suggesstion-box').empty();
      $.getJSON("/allbooks_panel/get_authors_name_search/" + $(this).val(), function(data) {
        $.each(data, function(index, item) {
          $("#suggesstion-box").show();
          $("#suggesstion-box").append(
            $('<li class="auth"></li>').val(item["id"]).html(item["name"])
          );
        });
      });
    });
    $(document).on('click', '.auth', function() {
      var authclass = $(this).val();
      $('#authorid').val(authclass);
      $('#authorname').val($(this).text());
      $("#suggesstion-box").hide();
    });

    $('#authors').on('change', function() {
      $('#authorname').empty();
      $.getJSON("/allbooks_panel/get_authors_name/" + $(this).val(), function(data) {
        $.each(data, function(index, item) {
          $('#authorname').val(item["name"]);
        });
      });
    });

    $('#tags').on('change', function() {
      $('#tagname').empty();
      $.getJSON("/allbooks_panel/get_tag_name/" + $(this).val(), function(data) {
        $.each(data, function(index, item) {
          $('#tagname').val(item["name"]);
        });
      });
    });

    $('#category_id').on('change', function() {
      $('#subcategory_id').empty();
      $.getJSON("/allbooks_panel/get_sub_categories/" + $(this).val(), function(data) {
        $('#subcategory_id').show();
        $.each(data, function(index, item) {
          $('#subcategory_id').append(
            $('<option></option>').val(item["id"]).html(item["name"])
          );
        });
      });
    });

    $('#add-details').on('change', function() {
      $('#show-details').toggle();
      $('#show-details').html('<div class="col-md-12">\
        <div class="form-group form-float">\
          <div class="form-line">\
            <textarea class="tinymce" name="details" placeholder="نبذة عن الكتاب">{{ old('
        details ') }}</textarea>\
            <label class="form-label">نبذة عن الكتاب</label>\
            @if ($errors->has('
        details '))\
            <label class="alert alert-danger">{{ $errors->first('
        details ') }}</label>\
            @endif\
          </div>\
        </div>\
      </div>');


      $('textarea.tinymce').tinymce({
        toolbar_mode: 'scrolling'
        , plugins: [
          'advlist autolink link image lists charmap print preview hr anchor pagebreak'
          , 'searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking'
          , 'table emoticons template paste help'
        ]
        , toolbar: 'undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | ' +
          'bullist numlist outdent indent | link image | print preview media fullscreen | ' +
          'forecolor backcolor emoticons | help'
        , menubar: 'file edit view insert format tools table help',
        // content_css: 'css/content.css'

        language: 'ar'
        , height: 300
          // , width: 720
      , });

    });



  });

</script>
@endpush
