@extends('BackEnd.Layouts.main')
@section('title')
{{ __('messages.Edit Article') }}
@endsection
@section('content')
<section class="content">
  <div class="container-fluid">
    @include('BackEnd.Layouts.breadcrumb')
    @if(session('success'))
    <div class="alert alert-success text-center">
      {{session("success")}}
    </div>
    @endif
    @if(session('error'))
    <div class="alert alert-danger text-center">
      {{ session('error') }}
    </div>
    @endif
    <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
          @include('BackEnd.Layouts.tableheader')
          <div class="body">
            <form id="form_validation" method="POST" action="{{ route('articles.update',$article->id) }}" enctype="multipart/form-data">
              @csrf
              <div class="row">
                <div class="col-md-1">
                  <div class="form-group default-select select2Style">
                    <select class="form-control select2" name="lang" data-placeholder="Select">
                      <option value="ar">عربي</option>
                      <option value="en" {{ $article->lang=='en'?'selected':'' }}>English</option>
                    </select>
                    {{-- <label>اللغة</label> --}}
                  </div>
                </div>
                <div class="col-md-11">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="title" value="{{ $article->title }}" required>
                      <label class="form-label">عنوان المقال</label>
                      @if ($errors->has('title'))
                      <label class="alert alert-danger">{{ $errors->first('title') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <textarea class="tinymce" name="details" placeholder="نص المقال">{{ $article->details }}</textarea>
                      <label class="form-label">نص المقال</label>
                      @if ($errors->has('details'))
                      <label class="alert alert-danger">{{ $errors->first('details') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-10">
                  <div class="file-field input-field">
                    <div class="btn">
                      <span>{{ __('messages.Choose a picture') }} (اختياري)</span>
                      <input type="file" name="image">
                    </div>
                    <div class="file-path-wrapper">
                      <input class="file-path validate" type="text" name="image" placeholder="{{ __('messages.Click to add a photo') }}">
                      <input class="file-path validate" type="hidden" name="old_image" value="{{ $article->getRawOriginal('image') }}">
                       @if ($errors->has('image'))
                      <label class="alert alert-danger">{{ $errors->first('image') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-2">
                  <img src="{{$article->image }}" alt="">
                </div>
                <div class="col-md-3">
                  <p>
                    <b>عرض في الرئيسية</b>
                  </p>
                  <div class="form-group default-select select2Style">
                    <select class="form-control select2" name="special_id" data-placeholder="Select">
                      <option value="1">نعم</option>
                      <option value="0" {{ $article->special_id==0?'selected':'' }}>لا</option>
                    </select>
                  </div>
                </div>
                <div class="col-md-3">
                  <p>
                    <b>تفعيل التعليقات</b>
                  </p>
                  <div class="form-group default-select select2Style">
                    <select class="form-control select2" name="allow_comments" data-placeholder="Select">
                      <option value="1">نعم</option>
                      <option value="0" {{ $article->allow_comments==0?'selected':'' }}>لا</option>

                    </select>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="input-field col s12">
                    <select class="icons" name="writer_id" required>
                      <option value="" disabled selected>اختر كاتب</option>
                      @foreach ($writers as $writer)
                      <option value="{{ $writer->id }}" data-icon="{{ $writer->image }}" {{ $writer->id==$article->writer_id?'selected':'' }}>{{ $writer->name }}</option>
                      @endforeach
                    </select>
                    <label>الكاتب</label>
                  </div>
                </div>
                <div class="col-md-3">
                  <p>
                    <b>حالة النشر</b>
                  </p>
                  <div class="demo-switch">
                    <div class="switch">
                      <label>منشور
                        <input type="checkbox" name="is_active" {{ $article->is_active==1?'checked':'' }}>
                        <span class="lever"></span>مسودة</label>
                    </div>
                  </div>
                </div>
                {{-- meta data --}}
                <div style="background: rgb(215, 249, 255);">
                  <div class="col-md-12">
                    <div class="form-group form-float">
                      <div class="form-line">
                        <input type="text" class="form-control" name="meta_title"
                          placeholder="عنوان Meta (اذا ترك فارغاً سيتم اعتماد عنوان المقال)"
                          value="{{ $article->meta_title }}">
                        {{-- <label class="form-label">عنوان Meta </label> --}}
                        @if ($errors->has('meta_title'))
                          <label class="alert alert-danger">{{ $errors->first('meta_title') }}</label>
                        @endif
                      </div>
                    </div>
                  </div>
                  <div class="col-md-12">
                    <div class="form-group form-float">
                      <div class="form-line">
                        <textarea class="tinymcexxx" name="meta_description"
                          placeholder="وصف Meta: اذا ترك فارغاً سيتم اعتماد جزء من تفاصيل المقال" style="height: 100px;">{{ $article->meta_description }}</textarea>
                        {{-- <label class="form-label"> وصف Meta</label> --}}
                        @if ($errors->has('meta_description'))
                          <label class="alert alert-danger">{{ $errors->first('meta_description') }}</label>
                        @endif
                      </div>
                    </div>
                  </div>
                  <div class="col-md-12">
                    <div class="card">
                      <div class="header">
                        <label class="form-label">كلمات مفتاحية (هاشتاغ)</label>
                      </div>
                      <div class="body">
                        <div class="form-group demo-tagsinput-area">
                          <div class="form-line">
                            <input type="text" name="tags[]" class="form-control" data-role="tagsinput" value="@foreach (explode(',',$article->tags) as $tgname){{ $tgname.',' }}@endforeach" placeholder="أضف كلمة ثم انقر enter">
                            {{-- <select class="form-control" id="select2-rtl-multiple" name="tags[]" multiple="multiple">
                              <optgroup label="">
                                @foreach ($tags as $tag)
                                <option value="{{ $tag->id }}"
                                  @foreach (explode(',',$article->tags) as $tgname) {{ $tgname==$tag->name?'selected':'' }} @endforeach>{{ $tag->name }}</option>
                                @endforeach
                            </optgroup>
                            </select> --}}
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                {{-- meta data --}}
                <button class="btn btn-primary waves-effect" type="submit">{{ __('messages.UPDATE') }}</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

@endsection
@push('plugin_js')
<script src="{{ asset('BackEnd/js/form.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/bundles/multiselect/js/jquery.multi-select.js') }}"></script>
<script src="{{ asset('BackEnd/js/bundles/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.js') }}"></script>
@endpush
@push('custom_js')
<script src="{{ asset('BackEnd/js/pages/forms/basic-form-elements.js') }}"></script>
<script src="{{ asset('BackEnd/js/tinymce/js/tinymce/tinymce.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/tinymce/js/tinymce/jquery.tinymce.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/pages/forms/advanced-form-elements.js') }}"></script>
@endpush

@push('tinymce')
<script>
  $(document).ready(function() {
    $('#add_image').on('click',function(){
    $('#gallery-content').append('<div class="col-md-12">\
      <div class="file-field input-field">\
        <div class="btn">\
          <span>صورة اضافية</span>\
          <input type="file" name="gallery[]">\
        </div>\
        <div class="file-path-wrapper">\
          <input class="file-path validate" type="text" name="gallery[]" placeholder="انقر لاختيار صورة اضافية للخبر">\
          @if ($errors->has('gallery'))\
          <label class="alert alert-danger">{{ $errors->first('gallery') }}</label>\
          @endif\
        </div>\
        <div class="form-check m-l-10">\
          <label class="form-check-label">\
            <input class="form-check-input" type="checkbox" id="checkbox" name="icon">\
            إضافة الشعار إلى الصورة\
            <span class="form-check-sign">\
              <span class="check"></span>\
            </span>\
          </label>\
        </div>\
      </div>\
    </div>');
    });
    $('#minus_button').on('click',function(){
    $('#gallery-content').children("div").last().remove();
    });

    $('textarea.tinymce').tinymce({
      toolbar_mode: 'scrolling'
      , plugins: [
        'advlist autolink link image lists charmap print preview hr anchor pagebreak'
        , 'searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking'
        , 'table emoticons template paste help'
      ]
      , toolbar: 'undo redo | cut copy paste | styleselect | bold italic | alignleft aligncenter alignright alignjustify | ' +
        'bullist numlist outdent indent | link image | print preview media fullscreen | ' +
        'forecolor backcolor emoticons | help'
      , menubar: 'file edit view insert format tools table help',
      // content_css: 'css/content.css'

      language: 'ar'
      , height: 500
        // , width: 720
    , });
  });
</script>
@endpush
