@extends('BackEnd.Layouts.main')
@section('title')
{{ __('messages.Edit Ad') }}
@endsection
@section('content')
<section class="content">
  <div class="container-fluid">
    @include('BackEnd.Layouts.breadcrumb')
    @if(session('success'))
    <div class="alert alert-success text-center">
      {{session("success")}}
    </div>
    @endif
    @if(session('error'))
    <div class="alert alert-danger text-center">
      {{ session('error') }}
    </div>
    @endif
    <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
          @include('BackEnd.Layouts.tableheader')
          <div class="body">
            <form id="form_validation" method="POST" action="{{ route('ads.update',$ad->id) }}" enctype="multipart/form-data">
              @csrf
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="name_ar" value="{{ json_decode($ad->name,true)['ar'] }}" required>
                      <label class="form-label">{{ __('messages.TITLE') }} ({{ __('messages.ARABIC') }})</label>
                      @if ($errors->has('name_ar'))
                      <label class="alert alert-danger">{{ $errors->first('name_ar') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="name_en" value="{{ json_decode($ad->name,true)['en'] }}" required>
                      <label class="form-label">{{ __('messages.TITLE') }} ({{ __('messages.ENGLISH') }})</label>
                      @if ($errors->has('name_en'))
                      <label class="alert alert-danger">{{ $errors->first('name_en') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-10">
                  <div class="file-field input-field">
                    <div class="btn">
                      <span>{{ __('messages.Choose a picture') }}</span>
                      <input type="file" name="image">
                    </div>
                    <div class="file-path-wrapper">
                      <input class="file-path validate" type="text" name="image" placeholder="{{ __('messages.Click to add a photo') }}">
                      <input class="file-path validate" type="hidden" name="old_image" value="{{ $ad->image }}">
                       @if ($errors->has('image'))
                      <label class="alert alert-danger">{{ $errors->first('image') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-2">
                  <img src="{{ asset('media/imgs/ads/'.$ad->image) }}" alt="">
                </div>
                <div class="col-md-12">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="url" value="{{ $ad->url }}" required>
                      <label class="form-label">{{ __('messages.Ad link') }}</label>
                      @if ($errors->has('url'))
                      <label class="alert alert-danger">{{ $errors->first('url') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-md-3">
                  <p>
                    <b>موضع عرض الاعلان</b>
                  </p>
                  <div class="form-group default-select select2Style">
                    <select class="form-control select2" name="adplace_id" data-placeholder="Select">
                      <option>اختر من القائمة</option>
                      @foreach ($ads_places as $pl)
                      <option value="{{ $pl->id }}" {{ $pl->id==$ad->adplace_id?'selected':'' }}>{{ json_decode($pl->name,true)['ar'] }}</option>
                      @endforeach
                    </select>
                  </div>
                </div>
                <div class="col-md-6">
                  <p>
                    <b>صفحات العرض</b>
                  </p>
                  <div class="form-group default-select select2Style">
                    <select class="form-control" id="select2-rtl-multiple" name="pages_id[]" multiple="multiple">
                      <optgroup label="">
                        @if (sizeof(explode(',', $ad->pages_id))>1)
                        @php
                          $page_ids = explode(',', $ad->pages_id);
                          $n=-1;
                        @endphp
                        @foreach ($ads_pages as $page)
                          @php
                            $n++;
                          @endphp
                          <option value="{{ $page->id }}" 
                             @foreach (explode(',', $ad->pages_id) as $pgs)
                             {{ $page->id==$pgs?'selected':'' }}
                             @endforeach
                            >{{ json_decode($page->name,true)['ar'] }}</option>
                          @endforeach
                          @else
                          <option value="{{ $page->id }}" {{ $page->id==$page_ids[0]?'selected':'' }}>{{ json_decode($page->name,true)['ar'] }}</option>
                          @endif
                      </optgroup>
                    </select>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group" style="display: block">
                    <div class="form-check m-l-10">
                      <label class="form-check-label">
                        <input class="form-check-input" type="checkbox" id="add-details" name="has_details" {{ $ad->has_details==1?'checked':'' }}>
                        إضافة صفحة تفاصيل
                        <span class="form-check-sign">
                          <span class="check"></span>
                        </span>
                        <span style="font-size:xx-small;padding-top: 20px;">هذا الاختيار يجعل النقر على الاعلان تعيد توجيهك الى صفحة تظهر تفاصيل الاعلان كاملة</span>
                      </label>
                    </div>
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <textarea class="tinymce" name="details_ar" placeholder="{{ __('messages.DETAILS') }} ({{ __('messages.ARABIC') }})">{{ json_decode($ad->details,true)['ar'] }}</textarea>
                      <label class="form-label">{{ __('messages.DETAILS') }} ({{ __('messages.ARABIC') }})</label>
                      @if ($errors->has('details_ar'))
                      <label class="alert alert-danger">{{ $errors->first('details_ar') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <textarea class="tinymce" name="details_en" placeholder="{{ __('messages.DETAILS') }} ({{ __('messages.ENGLISH') }})">{{ json_decode($ad->details,true)['en'] }}</textarea>
                      <label class="form-label">{{ __('messages.DETAILS') }} ({{ __('messages.ENGLISH') }})</label>
                      @if ($errors->has('details_en'))
                      <label class="alert alert-danger">{{ $errors->first('details_en') }}</label>
                      @endif
                    </div>
                  </div>
                </div>

                @ability(['super_admin'],[''])
                <div class="form-group" style="display: block">
                  <div class="form-check m-l-10">
                    <label class="form-check-label">
                      <input class="form-check-input" type="checkbox" id="checkbox" name="is_active" {{ $ad->is_active==1?'checked':'' }}>
                      {{ __('messages.PUBLISHED') }}
                      <span class="form-check-sign">
                        <span class="check"></span>
                      </span>
                    </label>
                  </div>
                </div>
                @endability
                <button class="btn btn-primary waves-effect" type="submit">{{ __('messages.UPDATE') }}</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
@endsection
@push('plugin_js')
<script src="{{ asset('BackEnd/js/form.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/bundles/multiselect/js/jquery.multi-select.js') }}"></script>
<script src="{{ asset('BackEnd/js/bundles/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.js') }}"></script>
@endpush
@push('custom_js')
<script src="{{ asset('BackEnd/js/pages/forms/basic-form-elements.js') }}"></script>
<script src="{{ asset('BackEnd/js/tinymce/js/tinymce/tinymce.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/tinymce/js/tinymce/jquery.tinymce.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/pages/forms/advanced-form-elements.js') }}"></script>
@endpush
@push('tinymce')
<script>
  $(document).ready(function() {
   

      $('textarea.tinymce').tinymce({
        toolbar_mode: 'scrolling'
        , plugins: [
          'advlist autolink link image lists charmap print preview hr anchor pagebreak'
          , 'searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking'
          , 'table emoticons template paste help'
        ]
        , toolbar: 'undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | ' +
          'bullist numlist outdent indent | link image | print preview media fullscreen | ' +
          'forecolor backcolor emoticons | help'
        , menubar: 'file edit view insert format tools table help',
        // content_css: 'css/content.css'

        language: 'ar'
        , height: 300
          // , width: 720
      , });

    



  });

</script>
@endpush

