@extends('BackEnd.Layouts.main')
@section('title')
{{ __('messages.Add Ad') }}
@endsection
@section('content')
<section class="content">
  <div class="container-fluid">
    @include('BackEnd.Layouts.breadcrumb')
      @if(session('success'))
      <div class="alert alert-success text-center">
        {{session("success")}}
      </div>
      @endif
      @if(session('error'))
      <div class="alert alert-danger text-center">
        {{ session('error') }}
      </div>
      @endif
    <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
          @include('BackEnd.Layouts.tableheader')
          <div class="body">
            <form id="form_validation" method="POST" action="{{ route('ads.store') }}" enctype="multipart/form-data">
              @csrf
              <div class="row">
                <div class="col-md-12">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="name_ar" value="{{ old('name_ar') }}" required>
                      <label class="form-label">{{ __('messages.TITLE') }} ({{ __('messages.ARABIC') }})</label>
                      @if ($errors->has('name_ar'))
                      <label class="alert alert-danger">{{ $errors->first('name_ar') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <input type="hidden" class="form-control" name="name_en" value="{{ old('name_en') }}">
                {{-- <div class="col-md-6">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="name_en" value="{{ old('name_en') }}" required>
                      <label class="form-label">{{ __('messages.TITLE') }} ({{ __('messages.ENGLISH') }})</label>
                      @if ($errors->has('name_en'))
                      <label class="alert alert-danger">{{ $errors->first('name_en') }}</label>
                      @endif
                    </div>
                  </div>
                </div> --}}
                <div class="col-md-12">
                  <div class="file-field input-field">
                    <div class="btn">
                      <span>{{ __('messages.Choose a picture') }}</span>
                      <input type="file"  name="image">
                    </div>
                    <div class="file-path-wrapper">
                      <input class="file-path validate" type="text" name="image" placeholder="{{ __('messages.Click to add a photo') }}">
                      @if ($errors->has('image'))
                      <label class="alert alert-danger">{{ $errors->first('image') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group form-float">
                    <div class="form-line">
                      <input type="text" class="form-control" name="url" value="{{ old('url') }}" required>
                      <label class="form-label">{{ __('messages.Ad link') }}</label>
                      @if ($errors->has('url'))
                      <label class="alert alert-danger">{{ $errors->first('url') }}</label>
                      @endif
                    </div>
                  </div>
                </div>
                <div class="col-md-3">
                  <p>
                    <b>موضع عرض الاعلان</b>
                  </p>
                  <div class="form-group default-select select2Style">
                    <select class="form-control select2" name="adplace_id" data-placeholder="Select">
                      <option>اختر من القائمة</option>
                      @if(false)
                     
                      @endif
                    </select>
                  </div>
                </div>
                <div class="col-md-6">
                  <p>
                    <b>صفحات العرض</b>
                  </p>
                  <div class="form-group default-select select2Style">
                    <select class="form-control" id="select2-rtl-multiple" name="pages_id[]" multiple="multiple">
                      <optgroup label="">
                        @if(false)
                       
                        @endif
                      </optgroup>
                    </select>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group" style="display: block">
                    <div class="form-check m-l-10">
                      <label class="form-check-label">
                        <input class="form-check-input" type="checkbox" id="add-details" name="has_details">
                        إضافة صفحة تفاصيل 
                        <span class="form-check-sign">
                          <span class="check"></span>
                        </span>
                        <span style="font-size:xx-small;padding-top: 20px;">هذا الاختيار يجعل النقر على الاعلان تعيد توجيهك الى صفحة تظهر تفاصيل الاعلان كاملة</span>
                      </label>
                    </div>
                  </div>
                </div>
                <div id="show-details"></div>
                @ability(['super_admin'],[''])
                <div class="form-group" style="display: block">
                  <div class="form-check m-l-10">
                    <label class="form-check-label">
                      <input class="form-check-input" type="checkbox" id="checkbox" name="is_active" checked>
                      {{ __('messages.PUBLISHED') }}
                      <span class="form-check-sign">
                        <span class="check"></span>
                      </span>
                    </label>
                  </div>
                </div>
                @endability
                <button class="btn btn-primary waves-effect" type="submit">{{ __('messages.Add') }}</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
@endsection
@push('plugin_js')
<script src="{{ asset('BackEnd/js/form.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/bundles/multiselect/js/jquery.multi-select.js') }}"></script>
<script src="{{ asset('BackEnd/js/bundles/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.js') }}"></script>
@endpush
@push('custom_js')
<script src="{{ asset('BackEnd/js/pages/forms/basic-form-elements.js') }}"></script>
<script src="{{ asset('BackEnd/js/tinymce/js/tinymce/tinymce.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/tinymce/js/tinymce/jquery.tinymce.min.js') }}"></script>
<script src="{{ asset('BackEnd/js/pages/forms/advanced-form-elements.js') }}"></script>
@endpush
@push('tinymce')
<script>
  $(document).ready(function() {
    $('#add-details').on('change',function(){
      $('#show-details').html('<div class="col-md-12">\
        <div class="form-group form-float">\
          <div class="form-line">\
            <textarea class="tinymce" name="details_ar" placeholder="{{ __('messages.DETAILS') }} ({{ __('messages.ARABIC') }})">{{ old('details_ar') }}</textarea>\
            <label class="form-label">{{ __('messages.DETAILS') }} ({{ __('messages.ARABIC') }})</label>\
            @if ($errors->has('details_ar'))\
            <label class="alert alert-danger">{{ $errors->first('details_ar') }}</label>\
            @endif\
          </div>\
        </div>\
      </div>\
      <div class="col-md-12">\
        <div class="form-group form-float">\
          <div class="form-line">\
            <textarea class="tinymce" name="details_en" placeholder="{{ __('messages.DETAILS') }} ({{ __('messages.ENGLISH') }})">{{ old('details_en') }}</textarea>\
            <label class="form-label">{{ __('messages.DETAILS') }} ({{ __('messages.ENGLISH') }})</label>\
            @if ($errors->has('details_en'))\
            <label class="alert alert-danger">{{ $errors->first('details_en') }}</label>\
            @endif\
          </div>\
        </div>\
      </div>');

      $('textarea.tinymce').tinymce({
      toolbar_mode: 'scrolling'
      , plugins: [
        'advlist autolink link image lists charmap print preview hr anchor pagebreak'
        , 'searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking'
        , 'table emoticons template paste help'
      ]
      , toolbar: 'undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | ' +
        'bullist numlist outdent indent | link image | print preview media fullscreen | ' +
        'forecolor backcolor emoticons | help'
      , menubar: 'file edit view insert format tools table help',
      // content_css: 'css/content.css'

      language: 'ar'
      , height: 300
        // , width: 720
    , });

    });


    
  });

</script>
@endpush

