<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=Edge">
  <meta content="width=device-width, initial-scale=1" name="viewport" />
  <title>@yield('title')</title>
  <!-- Favicon-->
  <link rel="icon" href="{{ asset('FrontEnd/images/favicon.png') }}" type="image/x-icon">
  <!-- Plugins Core Css -->
  <link href="{{ asset('BackEnd/js/bundles/bootstrap-colorpicker/dist/css/bootstrap-colorpicker.css') }}" rel="stylesheet">
  <link href="{{ asset('BackEnd/js/bundles/multiselect/css/multi-select.css') }}" rel="stylesheet">
  <link href="{{ asset('BackEnd/css/app.min.css') }}" rel="stylesheet">
  <link href="{{ asset('BackEnd/css/form.min.css') }}" rel="stylesheet">
  <!-- Custom Css -->
  <link href="{{ asset('BackEnd/css/style.css') }}" rel="stylesheet" />
  <!-- Theme style. You can choose a theme from css/themes instead of get all themes -->
  <link href="{{ asset('BackEnd/css/styles/all-themes.css') }}" rel="stylesheet" />
  <link href="{{ asset('BackEnd/css/custom.css') }}" rel="stylesheet" />
  <link href="{{ asset('BackEnd/fonts/fonts.css') }}" rel="stylesheet" />
</head>

<body class="rtl logo-black submenu-closed theme-black light menu_dark">
{{-- <body class="rtl logo-black theme-black dark menu_dark submenu-closed"> --}}
  <!-- Page Loader -->
  {{-- <div class="page-loader-wrapper">
    <div class="loader">
      <div class="m-t-30">
        <img class="loading-img-spin" src="{{ asset('BackEnd/images/loading.png') }}" width="20" height="20" alt="admin">
  </div>
  <p>Please wait...</p>
  </div>
  </div> --}}
  <!-- #END# Page Loader -->
  <!-- Overlay For Sidebars -->
  <div class="overlay"></div>
  <!-- #END# Overlay For Sidebars -->
  @include('BackEnd.Layouts.topbar')
  <div>
    @include('BackEnd.Layouts.leftmenu')
    @include('BackEnd.Layouts.rightmenu')
  </div>
  @yield('content')

  <!-- Plugins Js -->
  <script src="{{ asset('BackEnd/js/app.min.js') }}"></script>
  @stack('plugin_js')
  <!-- Custom Js -->
  <script src="{{ asset('BackEnd/js/admin.js') }}"></script>
  @stack('custom_js')
  @stack('login_page')
  @stack('is_active_ajax')
  @stack('tinymce')
  @stack('newspaper_ajax')
  <script>
    $(document).ready(function () {
      $('.slide_active').on('click', function() {
      var $slide_id = $(this).attr('id');
      // alert($slide_id);
      $.getJSON("/ye_panel/slides/status/" + $slide_id, function(data) {
        $.each(data, function(index, item) {
          if (item == 1)
            $('#span-' + $slide_id).html('<span style="color:#29b474">منشور</span>');
            $('#li-'+$slide_id).hide();
          if (item == -1)
            $('#span-' + $slide_id).html('<span style="color:#eb5757">غير منشور</span>');
          });
        });
      });
      $('.news_active').on('click',function(){
        var $news_id = $(this).attr('id');
        // alert($news_id);
        $.getJSON("/ye_panel/activities/status/" + $news_id, function(data) {
          $.each(data, function(index, item) {
            if(item==1)
            $('#span-'+$news_id).html('<span style="color:#29b474">منشور</span>');
            $('#li-'+$news_id).hide();
            if(item==-1)
            $('#span-'+$news_id).html('<span style="color:#eb5757">غير منشور</span>');
          });
        });
      });
      $('.project_active').on('click',function(){
        var $project_id = $(this).attr('id');
        // alert($project_id);
        $.getJSON("/ye_panel/projects/status/" + $project_id, function(data) {
          $.each(data, function(index, item) {
            if(item==1)
            $('#span-'+$project_id).html('<span style="color:#29b474">منشور</span>');
            $('#li-'+$project_id).hide();
            if(item==-1)
            $('#span-'+$project_id).html('<span style="color:#eb5757">غير منشور</span>');
          });
        });
      });
      $('.service_active').on('click',function(){
        var $service_id = $(this).attr('id');
        // alert($service_id);
        $.getJSON("/ye_panel/services/status/" + $service_id, function(data) {
          $.each(data, function(index, item) {
            if(item==1)
            $('#span-'+$service_id).html('<span style="color:#29b474">منشور</span>');
            $('#li-'+$service_id).hide();
            if(item==-1)
            $('#span-'+$service_id).html('<span style="color:#eb5757">غير منشور</span>');
          });
        });
      });
      $('.photo_active').on('click',function(){
        var $photo_id = $(this).attr('id');
        // alert($photo_id);
        $.getJSON("/ye_panel/photos/status/" + $photo_id, function(data) {
          $.each(data, function(index, item) {
            if(item==1)
            $('#span-'+$photo_id).html('<span style="color:#29b474">منشور</span>');
            $('#li-'+$photo_id).hide();
            if(item==-1)
            $('#span-'+$photo_id).html('<span style="color:#eb5757">غير منشور</span>');
          });
        });
      });
      $('.video_active').on('click',function(){
        var $video_id = $(this).attr('id');
        // alert($video_id);
        $.getJSON("/ye_panel/videos/status/" + $video_id, function(data) {
          $.each(data, function(index, item) {
            if(item==1)
            $('#span-'+$video_id).html('<span style="color:#29b474">منشور</span>');
            $('#li-'+$video_id).hide();
            if(item==-1)
            $('#span-'+$video_id).html('<span style="color:#eb5757">غير منشور</span>');
          });
        });
      });
    });
  </script>
</body>
